/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme;

public class SchemeLoadingOptions {
    public static final String OPTIONS_SCHEME = "opt:";
    public static final String NO_PREFIX = "no-";
    private static final String OPT_USE_DXFEED_PROPS = "dxprops";
    private static final String OPT_USE_SYSTEM_PROPS = "sysprops";
    private static final String OPT_DEBUG = "debug";
    private boolean useDXFeedProperties = false;
    private boolean useSystemProperties = false;
    private boolean debugMode = false;

    public boolean shouldUseDXFeedProperties() {
        return this.useDXFeedProperties;
    }

    public void useDXFeedProperties(boolean val) {
        this.useDXFeedProperties = val;
    }

    public boolean shouldUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void useSystemProperties(boolean val) {
        this.useSystemProperties = val;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean val) {
        this.debugMode = val;
    }

    public void setDXFeedDefaults() {
        this.useSystemProperties = true;
        this.useDXFeedProperties = true;
    }

    public void applyOptions(String opts) {
        if (!opts.startsWith(OPTIONS_SCHEME)) {
            throw new IllegalArgumentException("Wrong external scheme options string: \"" + opts + "\"");
        }
        String trimmedOpts = opts.substring(OPTIONS_SCHEME.length()).trim();
        block10: for (String o : trimmedOpts.split("\\s*:\\s*")) {
            boolean val = true;
            if (o.startsWith(NO_PREFIX)) {
                o = o.substring(NO_PREFIX.length());
                val = false;
            }
            switch (o) {
                case "dxprops": {
                    this.useDXFeedProperties = val;
                    continue block10;
                }
                case "sysprops": {
                    this.useSystemProperties = val;
                    continue block10;
                }
                case "debug": {
                    this.debugMode = val;
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Wrong external scheme options string: \"" + opts + "\", unknown option \"" + (val ? "" : NO_PREFIX) + o + "\"");
                }
            }
        }
    }
}

