/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.model;

import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.model.NamedEntity;
import com.dxfeed.scheme.model.SchemeModel;
import com.dxfeed.scheme.model.SchemeRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Deprecated
public final class SchemeRecordGenerator
extends NamedEntity<SchemeRecordGenerator> {
    private Type type = null;
    private String delimiter = null;
    private IteratorMode iteratorMode;
    private final Set<String> iterator = new LinkedHashSet<String>();
    private final Map<String, SchemeRecord> templates = new LinkedHashMap<String, SchemeRecord>();

    public SchemeRecordGenerator(String name, NamedEntity.Mode mode, String doc, String file) {
        super(name, mode, doc, file);
        this.iteratorMode = mode == NamedEntity.Mode.NEW ? IteratorMode.NEW : IteratorMode.APPEND;
    }

    public Type getType() {
        return this.type == null ? Type.SUFFIX : this.type;
    }

    public void setType(Type type) {
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    public String getDelimiter() {
        return this.delimiter == null ? "" : this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        Objects.requireNonNull(delimiter, "delimiter");
        this.delimiter = delimiter;
    }

    public void setIteratorMode(IteratorMode iteratorMode) {
        Objects.requireNonNull(iteratorMode, "mode");
        this.iteratorMode = iteratorMode;
    }

    public void addIteratorValue(String val) {
        this.iterator.add(Objects.requireNonNull(val, "val"));
    }

    public Collection<String> getIterator() {
        return Collections.unmodifiableCollection(this.iterator);
    }

    public void addTemplate(SchemeRecord t) throws SchemeException {
        Objects.requireNonNull(t, "t");
        if (!t.isTemplate()) {
            throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Record cannot be used as template in generator"), this.getFilesList());
        }
        if (!t.getParentGenerator().equals(this.getName())) {
            throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Record template from wrong generator"), this.getFilesList());
        }
        if (this.templates.put(t.getName(), t) != null) {
            throw new SchemeException(SchemeException.formatConflictMessage(t, this.getLastFile(), "Record template cannot be defined twice in one file"), t.getFilesList());
        }
    }

    public Collection<SchemeRecord> getTemplates() {
        return Collections.unmodifiableCollection(this.templates.values());
    }

    public List<String> getRecordsNames(SchemeRecord rec) {
        Objects.requireNonNull(rec, "rec");
        if (!rec.isTemplate()) {
            throw new IllegalArgumentException("Record cannot be used as template in generator");
        }
        if (!rec.getParentGenerator().equals(this.getName())) {
            throw new IllegalArgumentException("Record template from wrong generator");
        }
        String baseName = rec.getName();
        ArrayList<String> names = new ArrayList<String>();
        for (String s : this.iterator) {
            if (s.isEmpty()) {
                names.add(baseName);
                continue;
            }
            switch (this.type) {
                case PREFIX: {
                    names.add(s + (this.delimiter == null ? "" : this.delimiter) + baseName);
                    break;
                }
                case SUFFIX: {
                    names.add(baseName + (this.delimiter == null ? "" : this.delimiter) + s);
                }
            }
        }
        return names;
    }

    @Override
    void override(SchemeRecordGenerator newInstance) throws SchemeException {
        super.override(newInstance);
        if (newInstance.type != null) {
            this.type = newInstance.type;
        }
        if (newInstance.delimiter != null) {
            this.delimiter = newInstance.delimiter;
        }
        if (newInstance.iteratorMode == IteratorMode.NEW) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Iterator with mode=\"new\" could not be used to update existing iterator."), this.getFilesList());
        }
        if (newInstance.iteratorMode == IteratorMode.REPLACE) {
            this.iterator.clear();
        }
        this.iterator.addAll(newInstance.iterator);
        for (SchemeRecord t : newInstance.templates.values()) {
            SchemeRecord oldT = this.templates.get(t.getName());
            if (oldT == null) {
                this.templates.put(t.getName(), t);
                continue;
            }
            oldT.override(t);
        }
    }

    @Override
    void validateState(SchemeModel parent) throws SchemeException {
        super.validateState(parent);
        if (this.iteratorMode != IteratorMode.NEW) {
            throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Iterator with mode=\"" + this.iteratorMode.name().toLowerCase() + "\" must be update, not new object"), this.getFilesList());
        }
        for (SchemeRecord t : this.templates.values()) {
            t.validateState(parent);
        }
    }

    public String toString() {
        return "SchemeRecordGenerator{name='" + this.getName() + '\'' + '}';
    }

    public static enum IteratorMode {
        NEW,
        APPEND,
        REPLACE;

    }

    public static enum Type {
        PREFIX,
        SUFFIX;

    }
}

