/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.viewer.EventTableColumn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

abstract class EventTableModel<E extends MarketEvent>
implements TableModel {
    protected final ArrayList<E> events = new ArrayList();
    protected final ArrayList<Boolean> isUpdated = new ArrayList();
    protected final ArrayList<Integer> tags = new ArrayList();
    protected final ArrayList<Boolean> isDisabled = new ArrayList();
    protected int scheme = 0;
    protected TimeZone timeZone = TimeZone.getDefault();
    protected boolean frozen = false;
    private final Set<TableModelListener> modelListeners = new HashSet<TableModelListener>();
    public final EventTableColumn<E>[] columns;

    protected EventTableModel(EventTableColumn<E>[] columns) {
        this.columns = columns;
    }

    public abstract void eventsReceived(List<E> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTableChanged(TableModelEvent event) {
        Set<TableModelListener> set = this.modelListeners;
        synchronized (set) {
            for (TableModelListener listener : this.modelListeners) {
                listener.tableChanged(event);
            }
        }
    }

    protected void clearUpdates() {
        int minIndex = Integer.MAX_VALUE;
        int maxIndex = Integer.MIN_VALUE;
        for (int i = 0; i < this.isUpdated.size(); ++i) {
            if (!this.isUpdated.get(i).booleanValue()) continue;
            minIndex = Math.min(minIndex, i);
            maxIndex = Math.max(maxIndex, i);
            this.isUpdated.set(i, false);
        }
        if (minIndex != Integer.MAX_VALUE) {
            this.fireTableChanged(new TableModelEvent(this, minIndex, maxIndex));
        }
    }

    @Override
    public int getRowCount() {
        return this.events.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex].getCaption();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    TimeZone getTimeZone() {
        return this.timeZone;
    }

    void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].getValue((MarketEvent)this.events.get(rowIndex), this.isUpdated.get(rowIndex), this.isDisabled.get(rowIndex), this.tags.get(rowIndex), this.scheme, this.timeZone);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.modelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.modelListeners.remove(l);
    }

    public int getScheme() {
        return this.scheme;
    }

    public void setScheme(int scheme) {
        this.scheme = scheme;
        this.fireTableChanged(new TableModelEvent(this));
    }

    boolean isFrozen() {
        return this.frozen;
    }

    void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }
}

