/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.devexperts.util.DayUtil;
import com.dxfeed.viewer.ViewerCellValue;
import java.awt.Color;
import java.util.TimeZone;

class QuoteBoardCellSupport {
    QuoteBoardCellSupport() {
    }

    static ViewerCellValue priceValue(double value, State state, long updateTime) {
        return QuoteBoardCellSupport.textValue(ViewerCellValue.formatPrice(value), Double.isNaN(value) ? State.NOT_AVAILABLE : state, updateTime, 4);
    }

    static ViewerCellValue sizeValue(double value, long updateTime) {
        return QuoteBoardCellSupport.textValue(ViewerCellValue.formatSize(value), Double.isNaN(value) ? State.NOT_AVAILABLE : State.COMMON, updateTime, 4);
    }

    static ViewerCellValue exchangeValue(char value, long updateTime) {
        return QuoteBoardCellSupport.textValue(ViewerCellValue.formatExchange(value), value == '\uffff' ? State.NOT_AVAILABLE : State.COMMON, updateTime, 0);
    }

    static ViewerCellValue timeValue(long value, long updateTime, TimeZone timeZone) {
        return QuoteBoardCellSupport.textValue(ViewerCellValue.formatTime(value, timeZone), value == 0L || value == Long.MAX_VALUE ? State.NOT_AVAILABLE : State.COMMON, updateTime, 0);
    }

    static ViewerCellValue dayIdValue(int value, long updateTime) {
        State state;
        String description;
        if (value == 0 || value == Integer.MAX_VALUE) {
            description = "N/A";
            state = State.NOT_AVAILABLE;
        } else {
            description = Integer.toString(DayUtil.getYearMonthDayByDayId((int)value));
            state = State.COMMON;
        }
        return QuoteBoardCellSupport.textValue(description, state, updateTime, 0);
    }

    static ViewerCellValue boolValue(boolean value, long updateTime) {
        return QuoteBoardCellSupport.textValue(value ? "Y" : "N", State.COMMON, updateTime, 0);
    }

    static ViewerCellValue textValue(String text, State state, long updateTime, int alignment) {
        return QuoteBoardCellSupport.textValue(text, state, System.currentTimeMillis() < updateTime + 200L, alignment);
    }

    static ViewerCellValue textValue(String text, State state, boolean isUpdated, int alignment) {
        return new ViewerCellValue(text, isUpdated ? state.updatedColor : state.color, null, alignment);
    }

    public static enum State {
        NOT_AVAILABLE(Color.DARK_GRAY, Color.DARK_GRAY),
        COMMON(new Color(0xA0A0A0), Color.WHITE),
        INCREASED(new Color(314624), new Color(388608)),
        DECREASED(new Color(0xBE0000), Color.RED),
        FIRST_TIME(new Color(0xEEBB00), Color.YELLOW),
        INFO(new Color(9800610), Color.WHITE);

        public final Color color;
        public final Color updatedColor;

        private State(Color color, Color updatedColor) {
            this.color = color;
            this.updatedColor = updatedColor;
        }
    }
}

