/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.event.market.PriceType;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.Trade;
import com.dxfeed.viewer.QuoteBoardCellSupport;
import java.util.HashSet;
import java.util.Set;

class QuoteBoardTableRow {
    final String symbol;
    double lastPrice = Double.NaN;
    double lastSize = Double.NaN;
    QuoteBoardCellSupport.State lastState = QuoteBoardCellSupport.State.NOT_AVAILABLE;
    char lastExchange = (char)65535;
    long lastUpdateTime = Long.MAX_VALUE;
    double bidPrice = Double.NaN;
    double bidSize = Double.NaN;
    QuoteBoardCellSupport.State bidState = QuoteBoardCellSupport.State.NOT_AVAILABLE;
    char bidExchange = (char)65535;
    long bidUpdateTime = Long.MAX_VALUE;
    double askPrice = Double.NaN;
    double askSize = Double.NaN;
    QuoteBoardCellSupport.State askState = QuoteBoardCellSupport.State.NOT_AVAILABLE;
    char askExchange = (char)65535;
    long askUpdateTime = Long.MAX_VALUE;
    double highPrice = Double.NaN;
    double lowPrice = Double.NaN;
    double openPrice = Double.NaN;
    double closePrice = Double.NaN;
    int dayId = Integer.MAX_VALUE;
    PriceType dayCloseType = PriceType.PRELIMINARY;
    double prevClosePrice = Double.NaN;
    int prevDayId = Integer.MAX_VALUE;
    PriceType prevDayCloseType = PriceType.PRELIMINARY;
    double openInterest = Double.NaN;
    boolean tradingHalted = false;
    String haltStatusReason;
    long haltStartTime = Long.MAX_VALUE;
    long haltEndTime = Long.MAX_VALUE;
    double lowLimitPrice = Double.NaN;
    double highLimitPrice = Double.NaN;
    long highUpdateTime = Long.MAX_VALUE;
    long lowUpdateTime = Long.MAX_VALUE;
    long openUpdateTime = Long.MAX_VALUE;
    long closeUpdateTime = Long.MAX_VALUE;
    long prevCloseUpdateTime = Long.MAX_VALUE;
    long openInterestTime = Long.MAX_VALUE;
    double volume = Double.NaN;
    long volumeUpdateTime = Long.MAX_VALUE;
    String description;
    final Set<Integer> indexes = new HashSet<Integer>(1);

    QuoteBoardTableRow(String symbol) {
        this.symbol = symbol;
    }

    public void updateQuote(Quote quote, long curTime) {
        if (this.bidPrice != quote.getBidPrice() || this.bidSize != quote.getBidSizeAsDouble() || this.bidExchange != quote.getBidExchangeCode()) {
            this.bidUpdateTime = curTime;
            if (this.bidPrice != quote.getBidPrice()) {
                this.bidState = QuoteBoardTableRow.stateFor(quote.getBidPrice(), this.bidPrice);
                this.bidPrice = quote.getBidPrice();
            }
            this.bidSize = quote.getBidSizeAsDouble();
            if (Double.isNaN(this.bidSize) || this.bidSize == 0.0) {
                this.bidState = QuoteBoardCellSupport.State.COMMON;
            }
            this.bidExchange = quote.getBidExchangeCode();
        }
        if (this.askPrice != quote.getAskPrice() || this.askSize != quote.getAskSizeAsDouble() || this.askExchange != quote.getAskExchangeCode()) {
            this.askUpdateTime = curTime;
            if (this.askPrice != quote.getAskPrice()) {
                this.askState = QuoteBoardTableRow.stateFor(quote.getAskPrice(), this.askPrice);
                this.askPrice = quote.getAskPrice();
            }
            this.askSize = quote.getAskSizeAsDouble();
            if (Double.isNaN(this.askSize) || this.askSize == 0.0) {
                this.askState = QuoteBoardCellSupport.State.COMMON;
            }
            this.askExchange = quote.getAskExchangeCode();
        }
    }

    public void updateTrade(Trade trade, long curTime) {
        if (this.lastPrice != trade.getPrice() || this.lastSize != trade.getSizeAsDouble() || this.lastExchange != trade.getExchangeCode()) {
            this.lastUpdateTime = curTime;
            if (this.lastPrice != trade.getPrice()) {
                this.lastState = QuoteBoardTableRow.stateFor(trade.getPrice(), this.lastPrice);
                this.lastPrice = trade.getPrice();
            }
            this.lastSize = trade.getSizeAsDouble();
            this.lastExchange = trade.getExchangeCode();
        }
        if (this.volume != trade.getDayVolumeAsDouble()) {
            this.volumeUpdateTime = curTime;
            this.volume = trade.getDayVolumeAsDouble();
        }
    }

    public void updateSummary(Summary summary, long curTime) {
        if (this.highPrice != summary.getDayHighPrice()) {
            this.highUpdateTime = curTime;
            this.highPrice = summary.getDayHighPrice();
        }
        if (this.lowPrice != summary.getDayLowPrice()) {
            this.lowUpdateTime = curTime;
            this.lowPrice = summary.getDayLowPrice();
        }
        if (this.openPrice != summary.getDayOpenPrice()) {
            this.openUpdateTime = curTime;
            this.openPrice = summary.getDayOpenPrice();
        }
        if (this.closePrice != summary.getDayClosePrice()) {
            this.closeUpdateTime = curTime;
            this.closePrice = summary.getDayClosePrice();
        }
        if (this.dayCloseType != summary.getDayClosePriceType()) {
            this.closeUpdateTime = curTime;
            this.closePrice = summary.getDayClosePrice();
        }
        if (this.dayId != summary.getDayId()) {
            this.closeUpdateTime = curTime;
            this.dayId = summary.getDayId();
        }
        if (this.prevClosePrice != summary.getPrevDayClosePrice()) {
            this.prevCloseUpdateTime = curTime;
            this.prevClosePrice = summary.getPrevDayClosePrice();
        }
        if (this.prevDayCloseType != summary.getPrevDayClosePriceType()) {
            this.prevCloseUpdateTime = curTime;
            this.prevDayCloseType = summary.getPrevDayClosePriceType();
        }
        if (this.prevDayId != summary.getPrevDayId()) {
            this.prevCloseUpdateTime = curTime;
            this.prevDayId = summary.getPrevDayId();
        }
        if (this.openInterest != (double)summary.getOpenInterest()) {
            this.openInterestTime = curTime;
            this.openInterest = summary.getOpenInterest();
        }
    }

    public void updateProfile(Profile profile) {
        this.description = profile.getDescription();
        this.tradingHalted = profile.isTradingHalted();
        this.haltStatusReason = profile.getStatusReason();
        this.haltStartTime = profile.getHaltStartTime();
        this.haltEndTime = profile.getHaltEndTime();
        this.lowLimitPrice = profile.getLowLimitPrice();
        this.highLimitPrice = profile.getHighLimitPrice();
    }

    public static QuoteBoardCellSupport.State stateFor(double newValue, double oldValue) {
        return Double.isNaN(newValue) ? QuoteBoardCellSupport.State.NOT_AVAILABLE : (Double.isNaN(oldValue) ? QuoteBoardCellSupport.State.FIRST_TIME : (newValue > oldValue ? QuoteBoardCellSupport.State.INCREASED : (newValue < oldValue ? QuoteBoardCellSupport.State.DECREASED : QuoteBoardCellSupport.State.COMMON)));
    }

    public static QuoteBoardCellSupport.State stateFor(double value) {
        return Double.isNaN(value) ? QuoteBoardCellSupport.State.NOT_AVAILABLE : (value > 0.0 ? QuoteBoardCellSupport.State.INCREASED : (value < 0.0 ? QuoteBoardCellSupport.State.DECREASED : QuoteBoardCellSupport.State.COMMON));
    }
}

