/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.viewer.ViewerCellValue;
import java.awt.Color;
import java.util.TimeZone;

class TimeAndSalesCellSupport {
    private static final Color DEFAULT_COLOR = new Color(0xC0C0C0);
    private static final Color UPDATED_COLOR = Color.WHITE;
    private static final Color ALERT_COLOR = new Color(86, 0, 0, 218);

    TimeAndSalesCellSupport() {
    }

    public static ViewerCellValue textValue(String text, int alignment, boolean isUpdated, boolean isAlert) {
        return new ViewerCellValue(text, isUpdated ? UPDATED_COLOR : DEFAULT_COLOR, isAlert ? ALERT_COLOR : null, alignment);
    }

    public static ViewerCellValue exchangeValue(char exchange, boolean isUpdated, boolean isAlert) {
        return TimeAndSalesCellSupport.textValue(ViewerCellValue.formatExchange(exchange), 0, isUpdated, isAlert);
    }

    public static ViewerCellValue priceValue(double price, boolean isUpdated, boolean isAlert) {
        return TimeAndSalesCellSupport.textValue(ViewerCellValue.formatPrice(price), 4, isUpdated, isAlert);
    }

    public static ViewerCellValue sizeValue(double size, boolean isUpdated, boolean isAlert) {
        return TimeAndSalesCellSupport.textValue(ViewerCellValue.formatSize(size), 4, isUpdated, isAlert);
    }

    public static ViewerCellValue timeValue(long time, boolean isUpdated, boolean isAlert, TimeZone timeZone) {
        return TimeAndSalesCellSupport.textValue(ViewerCellValue.formatTime(time, timeZone), 0, isUpdated, isAlert);
    }
}

