/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer.tickchart;

import com.dxfeed.event.market.TimeAndSale;

public class VolumeAtPriceBar {
    private double buySize;
    private double sellSize;
    private double undefinedSize;

    public double getBuySize() {
        return this.buySize;
    }

    public double getSellSize() {
        return this.sellSize;
    }

    public double getUndefinedSize() {
        return this.undefinedSize;
    }

    public double getMaxSize() {
        return Math.max(this.buySize + this.undefinedSize, this.sellSize);
    }

    public void add(TimeAndSale timeAndSale) {
        switch (timeAndSale.getAggressorSide()) {
            case BUY: {
                this.buySize += timeAndSale.getSizeAsDouble();
                break;
            }
            case SELL: {
                this.sellSize += timeAndSale.getSizeAsDouble();
                break;
            }
            case UNDEFINED: {
                this.undefinedSize += timeAndSale.getSizeAsDouble();
                break;
            }
            default: {
                throw new IllegalStateException(timeAndSale.toString());
            }
        }
    }
}

