/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Scope;
import com.dxfeed.viewer.EventTableColumn;
import com.dxfeed.viewer.OrderCellSupport;
import com.dxfeed.viewer.ViewerCellValue;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

enum OrderTableColumn implements EventTableColumn<Order>
{
    EXCHANGE("X", 1){

        @Override
        public ViewerCellValue getValue(Order order, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return OrderCellSupport.exchangeValue(order.getExchangeCode(), isUpdated, isDisabled, tag, scheme);
        }
    }
    ,
    MARKET_MAKER("ID", 20){

        @Override
        public ViewerCellValue getValue(Order order, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            String symbol = order.getEventSymbol();
            String id = order.getMarketMaker();
            if (order.getScope() == Scope.REGIONAL) {
                Map mapping = symbol.startsWith(".") ? OPTION_EXCHANGE_MAP : STOCK_EXCHANGE_MAP;
                id = (String)mapping.get(Character.valueOf(order.getExchangeCode()));
                if (id == null) {
                    id = Character.toString(order.getExchangeCode());
                }
            } else if (order.getScope() == Scope.ORDER && (id == null || id.isEmpty())) {
                assert ("JKYZ".indexOf(order.getExchangeCode()) >= 0) : "illegal exchange code: " + order.getExchangeCode();
                id = (String)STOCK_EXCHANGE_MAP.get(Character.valueOf(order.getExchangeCode()));
            }
            return OrderCellSupport.textValue(id, isUpdated, isDisabled, tag, scheme, 0);
        }
    }
    ,
    PRICE("Price", 50){

        @Override
        public ViewerCellValue getValue(Order order, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return OrderCellSupport.priceValue(order.getPrice(), isUpdated, isDisabled, tag, scheme);
        }
    }
    ,
    SIZE("Size", 50){

        @Override
        public ViewerCellValue getValue(Order order, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return OrderCellSupport.sizeValue(order.getSizeAsDouble(), isUpdated, isDisabled, tag, scheme);
        }
    }
    ,
    TIME("Time", 130){

        @Override
        public ViewerCellValue getValue(Order order, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return OrderCellSupport.timeValue(order.getTime(), isUpdated, isDisabled, tag, scheme, timeZone);
        }
    }
    ,
    SCOPE("Scope", 30){

        @Override
        public ViewerCellValue getValue(Order order, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return OrderCellSupport.textValue(order.getScope().name(), isUpdated, isDisabled, tag, scheme, 0);
        }
    }
    ,
    PRICE_GROUP("Price Group", 30){

        @Override
        public ViewerCellValue getValue(Order order, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return OrderCellSupport.textValue(Integer.toString(tag), isUpdated, isDisabled, tag, scheme, 0);
        }
    };

    final String caption;
    final int preferredWidth;
    private static final Map<Character, String> STOCK_EXCHANGE_MAP;
    private static final Map<Character, String> OPTION_EXCHANGE_MAP;

    private OrderTableColumn(String caption, int preferredWidth) {
        this.caption = caption;
        this.preferredWidth = preferredWidth;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    static {
        STOCK_EXCHANGE_MAP = new HashMap<Character, String>();
        OPTION_EXCHANGE_MAP = new HashMap<Character, String>();
        STOCK_EXCHANGE_MAP.put(Character.valueOf('A'), "AMEX");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('B'), "BSE");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('C'), "NSX");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('D'), "FINRA");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('F'), "MF/MM");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('I'), "ISE");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('J'), "EDGE A");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('K'), "EDGE X");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('M'), "CHX");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('N'), "NYSE");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('P'), "ARCA");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('Q'), "NSDQ");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('S'), "NSDQ");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('T'), "NSDQ");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('U'), "OTCBB");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('V'), "OTC Other");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('W'), "CBOE");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('X'), "PSX");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('G'), "GLOBEX");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('Y'), "BATS Y");
        STOCK_EXCHANGE_MAP.put(Character.valueOf('Z'), "BATS Z");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('A'), "AMEX");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('B'), "BOX");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('C'), "CBOE");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('I'), "ISE");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('M'), "MIAX");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('N'), "ARCA");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('Q'), "NSDQ");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('T'), "BSE");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('W'), "C2");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('X'), "PHLX");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('G'), "GLOBEX");
        OPTION_EXCHANGE_MAP.put(Character.valueOf('Z'), "BATS");
    }
}

