/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.event.market.Order;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.ObservableListModelListener;
import com.dxfeed.viewer.EventTableModel;
import com.dxfeed.viewer.OrderTableColumn;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelEvent;

class OrderTableModel
extends EventTableModel<Order> {
    private final ObservableListModel<Order> list;
    private final Set<Order> updatedOrders = new HashSet<Order>();
    private double maxSize = 0.0;

    double getMaxSize() {
        return this.maxSize;
    }

    OrderTableModel(ObservableListModel<Order> list) {
        super(OrderTableColumn.values());
        this.list = list;
        list.addListener((ObservableListModelListener)new ObservableListModelListener<Order>(){

            public void modelChanged(ObservableListModelListener.Change<? extends Order> change) {
                OrderTableModel.this.processOrders((List<? extends Order>)change.getSource());
            }
        });
    }

    private boolean isTrashPrice(double price, double topPrice) {
        double percentDiff = Math.abs((price - topPrice) / topPrice);
        return topPrice < 1.0 && percentDiff > 0.9 || topPrice >= 1.0 && topPrice < 2.0 && percentDiff > 0.8 || topPrice >= 2.0 && topPrice < 5.0 && percentDiff > 0.7 || topPrice >= 5.0 && topPrice < 15.0 && percentDiff > 0.4 || topPrice >= 15.0 && topPrice < 50.0 && percentDiff > 0.25 || topPrice >= 50.0 && topPrice < 100.0 && percentDiff > 0.2 || topPrice >= 100.0 && topPrice < 200.0 && percentDiff > 0.1 || topPrice >= 200.0 && topPrice < 500.0 && percentDiff > 0.05 || topPrice >= 500.0 && topPrice < 1000.0 && percentDiff > 0.04 || topPrice >= 1000.0 && topPrice < 10000.0 && percentDiff > 0.03 || topPrice >= 10000.0 && percentDiff > 0.02;
    }

    public void processOrders(List<? extends Order> orderEvents) {
        if (this.frozen) {
            return;
        }
        this.events.clear();
        this.isUpdated.clear();
        this.isDisabled.clear();
        this.tags.clear();
        double prevPrice = 0.0;
        int priceGroup = 0;
        this.maxSize = 0.0;
        double topPrice = 1.0;
        if (this.list.size() > 0) {
            topPrice = ((Order)this.list.get(0)).getPrice();
        }
        for (Order order : this.list) {
            this.events.add(order);
            this.isUpdated.add(this.updatedOrders.contains(order));
            if (prevPrice != order.getPrice()) {
                ++priceGroup;
            }
            this.tags.add(priceGroup);
            prevPrice = order.getPrice();
            boolean thisPriceIsTrash = this.isTrashPrice(order.getPrice(), topPrice);
            if (priceGroup <= 15 && !thisPriceIsTrash && order.getSizeAsDouble() > this.maxSize) {
                this.maxSize = order.getSizeAsDouble();
            }
            this.isDisabled.add(thisPriceIsTrash);
        }
        this.updatedOrders.clear();
        for (Order order : orderEvents) {
            this.updatedOrders.add(order);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void eventsReceived(List<Order> orderEvents) {
    }
}

