/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileReader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public class SuggestMenu
extends JPopupMenu
implements ActionListener {
    public static final int DEFAULT_SUGGEST_LIMIT = 10;
    public static final int DELAY = 200;
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("YYYYMMDD");
    public final String prefix;
    public final int limit;
    public final String ipfAddress;
    public final String date;
    public final List<InstrumentProfile> ipfList;
    public final JTextField textField;
    private final Action symbolSelected;
    private final Component invoker;
    private final String user;
    private final String password;
    private SwingWorker<List<InstrumentProfile>, Void> downloadTask;
    private Timer timer;

    public SuggestMenu(String prefix, Action symbolSelected, Component invoker, JTextField textField, String ipfAddress, List<InstrumentProfile> ipfList) {
        this(prefix, 10, symbolSelected, ipfAddress, null, ipfList, invoker, textField, null, null);
    }

    public SuggestMenu(String prefix, Action symbolSelected, Component invoker, JTextField textField, String ipfAddress, List<InstrumentProfile> ipfList, String user, String password) {
        this(prefix, 10, symbolSelected, ipfAddress, null, ipfList, invoker, textField, user, password);
    }

    public SuggestMenu(String prefix, int limit, Action symbolSelected, String ipfAddress, Date date, List<InstrumentProfile> ipfList, Component invoker, JTextField textField, String user, String password) {
        this.prefix = prefix;
        this.limit = limit;
        this.ipfAddress = ipfAddress;
        this.ipfList = ipfList;
        this.date = date == null ? null : DATE_FORMATTER.format(date);
        this.symbolSelected = symbolSelected;
        this.invoker = invoker;
        this.textField = textField;
        this.user = user;
        this.password = password;
        if (!prefix.isEmpty()) {
            this.startDownload();
            this.startTimer();
        }
        this.setLightWeightPopupEnabled(true);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.downloadTask != null) {
            this.downloadTask.cancel(true);
            this.downloadTask = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<InstrumentProfile> list;
        if (!this.downloadTask.isDone()) {
            return;
        }
        this.timer.stop();
        try {
            list = this.downloadTask.get();
        }
        catch (InterruptedException ignore) {
            return;
        }
        catch (ExecutionException what) {
            what.printStackTrace();
            return;
        }
        for (InstrumentProfile instrumentProfile : list) {
            String text = instrumentProfile.getSymbol() + " (" + instrumentProfile.getDescription() + ")";
            JMenuItem item = new JMenuItem(text);
            item.addActionListener(this.symbolSelected);
            this.add(item);
        }
        this.show(this.invoker, this.textField.getX(), this.textField.getY() + this.textField.getHeight());
        this.textField.requestFocusInWindow();
    }

    private void startDownload() {
        this.downloadTask = this.ipfList == null ? new WebServiceDownloader() : new LocalDownloader();
        this.downloadTask.execute();
    }

    private void startTimer() {
        this.timer = new Timer(200, this);
        this.timer.start();
    }

    private class WebServiceDownloader
    extends SwingWorker<List<InstrumentProfile>, Void> {
        public final String needle;

        private WebServiceDownloader() {
            this.needle = SuggestMenu.this.prefix;
        }

        @Override
        protected List<InstrumentProfile> doInBackground() throws Exception {
            InstrumentProfileReader reader = new InstrumentProfileReader();
            String url = SuggestMenu.this.ipfAddress + "?mode=ui&text=" + this.needle + "&limit=" + SuggestMenu.this.limit;
            if (SuggestMenu.this.date != null) {
                // empty if block
            }
            List list = reader.readFromFile(url, SuggestMenu.this.user, SuggestMenu.this.password);
            return list;
        }
    }

    private class LocalDownloader
    extends SwingWorker<List<InstrumentProfile>, Void> {
        public final String needle;

        private LocalDownloader() {
            this.needle = SuggestMenu.this.prefix;
        }

        @Override
        protected List<InstrumentProfile> doInBackground() throws Exception {
            ArrayList<InstrumentProfile> result = new ArrayList<InstrumentProfile>(SuggestMenu.this.limit);
            for (InstrumentProfile ipf : SuggestMenu.this.ipfList) {
                if (!ipf.getSymbol().startsWith(this.needle)) continue;
                result.add(ipf);
                if (result.size() != SuggestMenu.this.limit) continue;
                break;
            }
            return result;
        }
    }
}

