/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.viewer.EventTableColumn;
import com.dxfeed.viewer.SaleConditions;
import com.dxfeed.viewer.TimeAndSalesCellSupport;
import com.dxfeed.viewer.ViewerCellValue;
import java.util.TimeZone;

enum TimeAndSalesTableColumn implements EventTableColumn<TimeAndSale>
{
    TIME("Time", 150){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.timeValue(timeAndSale.getTime(), isUpdated, !timeAndSale.isValidTick(), timeZone);
        }
    }
    ,
    ID("ID", 150){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(Long.toString(timeAndSale.getIndex()), 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    EXCHANGE("X", 1){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.exchangeValue(timeAndSale.getExchangeCode(), isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    BID("Bid", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.priceValue(timeAndSale.getBidPrice(), isUpdated, !timeAndSale.isValidTick() || timeAndSale.getBidPrice() > timeAndSale.getAskPrice() || timeAndSale.getPrice() > timeAndSale.getAskPrice());
        }
    }
    ,
    ASK("Ask", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.priceValue(timeAndSale.getAskPrice(), isUpdated, !timeAndSale.isValidTick() || timeAndSale.getBidPrice() > timeAndSale.getAskPrice() || timeAndSale.getPrice() < timeAndSale.getBidPrice());
        }
    }
    ,
    PRICE("Price", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.priceValue(timeAndSale.getPrice(), isUpdated, !timeAndSale.isValidTick() || timeAndSale.getPrice() < timeAndSale.getBidPrice() || timeAndSale.getPrice() > timeAndSale.getAskPrice());
        }
    }
    ,
    SIZE("Size", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.sizeValue(timeAndSale.getSizeAsDouble(), isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    SALE_CONDITIONS("Conditions", 30){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(timeAndSale.getExchangeSaleConditions(), 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    SALE_CONDITIONS_DESCRIPTION("Conditions Description", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(SaleConditions.getSaleConditionsDescription(timeAndSale.getEventSymbol(), timeAndSale.getExchangeSaleConditions()), 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    AGGRESSOR_SIDE("Aggressor", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(timeAndSale.getAggressorSide().toString(), 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    CANCEL("Cancel", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(timeAndSale.isCancel() ? "Y" : "N", 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    CORRECTION("Correction", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(timeAndSale.isCorrection() ? "Y" : "N", 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    ETH("ETH", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(timeAndSale.isExtendedTradingHours() ? "Y" : "N", 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    SPREAD("Spread", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(timeAndSale.isSpreadLeg() ? "Y" : "N", 0, isUpdated, !timeAndSale.isValidTick());
        }
    }
    ,
    VALID("Valid Tick", 50){

        @Override
        public ViewerCellValue getValue(TimeAndSale timeAndSale, boolean isUpdated, boolean isDisabled, int tag, int scheme, TimeZone timeZone) {
            return TimeAndSalesCellSupport.textValue(timeAndSale.isValidTick() ? "Y" : "N", 0, isUpdated, !timeAndSale.isValidTick());
        }
    };

    final String caption;
    final int preferredWidth;

    private TimeAndSalesTableColumn(String caption, int preferredWidth) {
        this.caption = caption;
        this.preferredWidth = preferredWidth;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }
}

