/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice;

import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandleSymbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventSymbolMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Map<CandleSymbol, String> candleSymbols = new ConcurrentHashMap<CandleSymbol, String>();

    public Object resolveEventSymbolMapping(Class<?> eventType, String eventSymbol) {
        if (!Candle.class.isAssignableFrom(eventType)) {
            return eventSymbol;
        }
        return this.resolveCandleSymbol(eventSymbol);
    }

    public List<?> resolveEventSymbolMappings(Class<?> eventType, List<String> symbols) {
        if (!Candle.class.isAssignableFrom(eventType)) {
            return symbols;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String symbol : symbols) {
            result.add(this.resolveCandleSymbol(symbol));
        }
        return result;
    }

    public void cleanupEventSymbolMapping(Class<?> eventType, DXFeedSubscription<?> sub) {
        if (eventType != Candle.class) {
            return;
        }
        if (sub == null) {
            this.candleSymbols.clear();
        } else {
            this.candleSymbols.keySet().retainAll(sub.getSymbols());
        }
    }

    private Object resolveCandleSymbol(String eventSymbol) {
        CandleSymbol candleSymbol = CandleSymbol.valueOf((String)eventSymbol);
        this.candleSymbols.put(candleSymbol, eventSymbol);
        return candleSymbol;
    }

    public String get(Object symbolObject) {
        if (symbolObject instanceof String) {
            return (String)symbolObject;
        }
        String s = this.candleSymbols.get(symbolObject);
        return s == null ? symbolObject.toString() : s;
    }
}

