/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.comet;

import com.devexperts.logging.Logging;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Queue;
import org.cometd.bayeux.Promise;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;

public class CometReflectionUtil {
    private static final Logging log = Logging.getLogging(CometReflectionUtil.class);
    private static boolean reflectionIssueHappened;
    private static final Field END_POINT_SESSION_FIELD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sessionImplCleanup(ServerSessionImpl sessionImpl) {
        try {
            Object flusher = CometReflectionUtil.extractFlusher(sessionImpl);
            if (flusher == null) {
                return;
            }
            Queue<?> queue = CometReflectionUtil.extractFlusherQueueUnsafe(flusher);
            Object object = flusher;
            synchronized (object) {
                Object entryObject;
                if (queue.isEmpty()) {
                    return;
                }
                log.info("Found non-empty Flusher queue: " + queue.size());
                while ((entryObject = queue.poll()) != null) {
                    Object promiseInstance;
                    Object serverMessageQueueInstance = CometReflectionUtil.getPrivateFieldByName(entryObject, "_queue");
                    if (serverMessageQueueInstance instanceof List) {
                        List serverMessageQueue = (List)serverMessageQueueInstance;
                        serverMessageQueue.clear();
                    }
                    if (!((promiseInstance = CometReflectionUtil.getPrivateFieldByName(entryObject, "_promise")) instanceof Promise)) continue;
                    Promise promise = (Promise)promiseInstance;
                    promise.fail((Throwable)new IllegalStateException("ServerSessionImpl is closed"));
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            CometReflectionUtil.reportReflectionIssue("Field not found in decomposition of ServerSessionImpl class.", e);
        }
    }

    static Object extractFlusher(AbstractWebSocketEndPoint endPoint) {
        try {
            return CometReflectionUtil.extractFlusherUnsafe(endPoint);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            CometReflectionUtil.reportReflectionIssue("Flusher queue not found in AbstractWebSocketEndPoint.", e);
            return null;
        }
    }

    static Queue<?> extractFlusherQueue(AbstractWebSocketEndPoint endPoint) {
        try {
            return CometReflectionUtil.extractFlusherQueueUnsafe(CometReflectionUtil.extractFlusher(endPoint));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            CometReflectionUtil.reportReflectionIssue("Flusher queue not found in AbstractWebSocketEndPoint.", e);
            return null;
        }
    }

    static ServerSessionImpl extractSessionInstance(AbstractWebSocketEndPoint endPoint) {
        try {
            return (ServerSessionImpl)CometReflectionUtil.getPrivateFieldByField(endPoint, END_POINT_SESSION_FIELD);
        }
        catch (IllegalAccessException e) {
            CometReflectionUtil.reportReflectionIssue("ServerSessionImpl not found in AbstractWebSocketEndPoint.Context.", e);
            return null;
        }
    }

    private static Object extractFlusherUnsafe(AbstractWebSocketEndPoint endPoint) throws NoSuchFieldException, IllegalAccessException {
        Object flusherInstance = CometReflectionUtil.getPrivateFieldByName(endPoint, "flusher", AbstractWebSocketEndPoint.class);
        if (flusherInstance == null) {
            throw new IllegalAccessException("No reflection exceptions but Flusher instance not found in decomposition of AbstractWebSocketEndPoint.");
        }
        return flusherInstance;
    }

    private static Queue<?> extractFlusherQueueUnsafe(Object flusherInstance) throws NoSuchFieldException, IllegalAccessException {
        Object queueInstance = CometReflectionUtil.getPrivateFieldByName(flusherInstance, "_entries");
        if (!(queueInstance instanceof Queue)) {
            throw new IllegalAccessException("No reflection exceptions but Queue<> field of Flusher not found in decomposition of AbstractWebSocketEndPoint.");
        }
        return (Queue)queueInstance;
    }

    private static Object extractFlusher(ServerSessionImpl sessionImpl) throws NoSuchFieldException, IllegalAccessException {
        Object schedulerInstance = CometReflectionUtil.getPrivateFieldByName(sessionImpl, "_scheduler");
        if (schedulerInstance != null) {
            Object flusherInstance;
            Object delegateInstance = CometReflectionUtil.getPrivateFieldByName(schedulerInstance, "this$0");
            if (delegateInstance != null && (flusherInstance = CometReflectionUtil.getPrivateFieldByName(delegateInstance, "flusher", AbstractWebSocketEndPoint.class)) != null) {
                return flusherInstance;
            }
        } else {
            return null;
        }
        throw new IllegalAccessException("No reflection exceptions but field not found in decomposition of ServerSessionImpl class.");
    }

    private static Object getPrivateFieldByName(Object instance, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return CometReflectionUtil.getPrivateFieldByName(instance, fieldName, instance.getClass());
    }

    private static Object getPrivateFieldByName(Object instance, String fieldName, Class<?> instanceClass) throws NoSuchFieldException, IllegalAccessException {
        Field field = instanceClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return CometReflectionUtil.getPrivateFieldByField(instance, field);
    }

    private static Object getPrivateFieldByField(Object instance, Field field) throws IllegalAccessException {
        return field.get(instance);
    }

    private static void reportReflectionIssue(String details, ReflectiveOperationException exception) {
        if (reflectionIssueHappened) {
            return;
        }
        log.error("Incompatibility in CometD runtime version detected:");
        log.error(details, (Throwable)exception);
        log.error("The application will continue running but may fail to detect and mitigate some resource leak conditions.");
        log.error("This should normally never happen, please report the incident to development team.");
        reflectionIssueHappened = true;
    }

    static {
        try {
            END_POINT_SESSION_FIELD = AbstractWebSocketEndPoint.class.getDeclaredField("_session");
        }
        catch (NoSuchFieldException e) {
            CometReflectionUtil.reportReflectionIssue("AbstractWebSocketEndPoint._session field not found", e);
            throw new IllegalStateException(e);
        }
        END_POINT_SESSION_FIELD.setAccessible(true);
    }
}

