/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.comet;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class DelayableExecutor
implements Executor {
    private final Supplier<Executor> executorSupplier;
    private final Queue<Runnable> delayedTasks = new ArrayDeque<Runnable>();
    private boolean delayProcessing;

    public DelayableExecutor(Supplier<Executor> executorSupplier) {
        this.executorSupplier = executorSupplier;
    }

    @Override
    public synchronized void execute(Runnable task) {
        this.delayedTasks.add(task);
        if (!this.delayProcessing) {
            this.flush();
        }
    }

    synchronized void setDelayProcessing(boolean delayProcessing) {
        this.delayProcessing = delayProcessing;
        if (!delayProcessing) {
            this.flush();
        }
    }

    private void flush() {
        while (!this.delayedTasks.isEmpty()) {
            this.executorSupplier.get().execute(this.delayedTasks.remove());
        }
    }
}

