/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice;

import com.devexperts.qd.QDFilter;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.impl.DXEndpointImpl;
import com.dxfeed.api.impl.DXFeedImpl;
import com.dxfeed.event.EventType;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.market.MarketEvent;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DXFeedContext {
    public static final DXFeedContext INSTANCE = new DXFeedContext();
    public static final String CONFIG_CONTEXT = "java:comp/env/dxfeed.properties";
    public static final String FILTER_PARAM = DXFeedContext.class.getName() + ".filter";
    private final Map<String, Class<? extends EventType<?>>> eventTypes = new TreeMap();
    private int refCount;
    private DXEndpoint endpoint;
    private DXFeed feed;
    private Map<String, DXFeedImpl> filteredFeeds = new ConcurrentHashMap<String, DXFeedImpl>();

    private DXFeedContext() {
    }

    public synchronized void acquire() {
        if (this.refCount++ > 0) {
            return;
        }
        this.runInScratchThread("DXFeedContext-Init", new Runnable(){

            @Override
            public void run() {
                DXFeedContext.this.init();
            }
        });
    }

    public synchronized void release() {
        if (--this.refCount > 0) {
            return;
        }
        this.runInScratchThread("DXFeedContext-Shutdown", new Runnable(){

            @Override
            public void run() {
                DXFeedContext.this.shutdown();
            }
        });
    }

    private void init() {
        this.endpoint = this.newBuilder().build();
        this.feed = this.endpoint.getFeed();
        for (Class eventType : this.endpoint.getEventTypes()) {
            this.eventTypes.put(eventType.getSimpleName(), eventType);
        }
    }

    private void shutdown() {
        for (DXFeedImpl feed : this.filteredFeeds.values()) {
            feed.closeImpl();
        }
        this.endpoint.close();
        this.endpoint = null;
        this.feed = null;
        this.filteredFeeds.clear();
        this.eventTypes.clear();
    }

    public Map<String, Class<? extends EventType<?>>> getEventTypes() {
        return this.eventTypes;
    }

    public EnumMap<Group, Map<String, Class<? extends EventType<?>>>> getGroupedEventTypes() {
        EnumMap result = new EnumMap(Group.class);
        for (Class<EventType<?>> eventType : this.eventTypes.values()) {
            Group group = Candle.class.isAssignableFrom(eventType) ? Group.CANDLE : (TimeSeriesEvent.class.isAssignableFrom(eventType) ? Group.TIME_SERIES : (IndexedEvent.class.isAssignableFrom(eventType) ? Group.INDEXED : (MarketEvent.class.isAssignableFrom(eventType) ? Group.MARKET : Group.OTHER)));
            Map<String, Class<EventType<?>>> m = result.get((Object)group);
            if (m == null) {
                m = new TreeMap();
                result.put(group, m);
            }
            m.put(eventType.getSimpleName(), eventType);
        }
        return result;
    }

    public DXEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DXFeed getFeed() {
        return this.feed;
    }

    @Deprecated
    public DXFeed getFeed(QDFilter filter) {
        Objects.requireNonNull(filter, "filter");
        if (!(this.endpoint instanceof DXEndpointImpl)) {
            throw new IllegalStateException("Unsupported DXEndpoint implementation!");
        }
        return (DXFeed)this.filteredFeeds.computeIfAbsent(filter.toString(), key -> new DXFeedImpl((DXEndpointImpl)this.endpoint, filter));
    }

    public DXEndpoint.Builder newBuilder() {
        DXEndpoint.Builder builder = DXEndpoint.newBuilder();
        String configFilePath = this.loadConfigFilePath();
        if (configFilePath != null) {
            builder.withProperty("dxfeed.properties", configFilePath);
        }
        return builder;
    }

    private String loadConfigFilePath() {
        String string;
        InitialContext ctx = new InitialContext();
        try {
            string = (String)ctx.lookup(CONFIG_CONTEXT);
        }
        catch (Throwable throwable) {
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException e) {
                return null;
            }
        }
        ctx.close();
        return string;
    }

    private void runInScratchThread(String threadName, Runnable runnable) {
        Thread thread = new Thread(runnable, threadName);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static enum Group {
        MARKET("Market events", "javadoc/com/dxfeed/event/market/MarketEvent.html", "MarketEvent"),
        CANDLE("Candle symbol events", "javadoc/com/dxfeed/event/candle/CandleSymbol.html", "CandleSymbol"),
        TIME_SERIES("Other non-candle time series events", "javadoc/com/dxfeed/event/TimeSeriesEvent.html", "TimeSeriesEvent"),
        INDEXED("Indexed events", "javadoc/com/dxfeed/event/IndexedEvent.html", "IndexedEvent"),
        OTHER("Other events", "javadoc/com/dxfeed/event/EventType.html", "EventType");

        public final String title;
        public final String seeHRef;
        public final String seeName;

        private Group(String title, String seeHRef, String seeName) {
            this.title = title;
            this.seeHRef = seeHRef;
            this.seeName = seeName;
        }
    }
}

