/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.comet;

import com.devexperts.util.TimePeriod;
import java.util.Comparator;
import java.util.Objects;

class SessionStats
implements Cloneable {
    public String sessionId;
    public volatile int numSessions;
    public volatile long createTime = -1L;
    public volatile long lastActiveTime = -1L;
    public volatile long lastSendTime = -1L;
    public volatile int maxQueueSize;
    public volatile int queueSize;
    public volatile int subSize;
    public volatile int subTimeSeriesSize;
    public volatile long writeEvents;
    public volatile long write;
    public volatile long writeMeta;
    public volatile long readEvents;
    public volatile long read;
    public volatile long readMeta;

    SessionStats() {
    }

    public static Comparator<SessionStats> getComparator(String column) {
        switch (Objects.requireNonNull(column).trim().toLowerCase()) {
            case "id": {
                return Comparator.comparing(stats -> stats.sessionId);
            }
            case "read_mps": {
                return Comparator.comparing(stats -> stats.readEvents).reversed();
            }
            case "read": {
                return Comparator.comparing(stats -> stats.read + stats.readMeta).reversed();
            }
            case "write_mps": {
                return Comparator.comparing(stats -> stats.writeEvents).reversed();
            }
            case "write": {
                return Comparator.comparing(stats -> stats.write + stats.writeMeta).reversed();
            }
            case "queue": {
                return Comparator.comparing(stats -> stats.queueSize).reversed();
            }
            case "time": {
                return Comparator.comparing(stats -> stats.createTime);
            }
            case "inactivity": {
                return Comparator.comparing(stats -> stats.lastActiveTime);
            }
            case "send_inactivity": {
                return Comparator.comparing(stats -> stats.lastSendTime);
            }
        }
        throw new IllegalArgumentException("Unknown sort column: " + column);
    }

    public void regSubscription(int size, boolean timeSeries) {
        if (timeSeries) {
            this.subTimeSeriesSize = size;
        } else {
            this.subSize = size;
        }
    }

    public void regQueueSize(int size) {
        this.queueSize = size;
        if (size > this.maxQueueSize) {
            this.maxQueueSize = size;
        }
    }

    public void clear() {
        this.numSessions = 0;
        this.createTime = 0L;
        this.lastActiveTime = 0L;
        this.maxQueueSize = 0;
        this.queueSize = 0;
        this.subSize = 0;
        this.subTimeSeriesSize = 0;
        this.writeEvents = 0L;
        this.write = 0L;
        this.writeMeta = 0L;
        this.readEvents = 0L;
        this.read = 0L;
        this.readMeta = 0L;
    }

    public SessionStats clone() {
        try {
            return (SessionStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public void accumulate(SessionStats other, boolean up) {
        int maxSize = other.maxQueueSize;
        if (maxSize > this.maxQueueSize) {
            this.maxQueueSize = maxSize;
        }
        this.sessionId = other.sessionId;
        int sizeMultiplier = up ? 1 : 0;
        this.queueSize += other.queueSize * sizeMultiplier;
        this.subSize += other.subSize * sizeMultiplier;
        this.subTimeSeriesSize += other.subTimeSeriesSize * sizeMultiplier;
        this.numSessions += other.numSessions * sizeMultiplier;
        this.createTime += other.createTime * (long)sizeMultiplier;
        this.lastActiveTime += other.lastActiveTime * (long)sizeMultiplier;
        this.lastSendTime += other.lastSendTime * (long)sizeMultiplier;
        int multiplier = up ? 1 : -1;
        this.writeEvents += other.writeEvents * (long)multiplier;
        this.write += other.write * (long)multiplier;
        this.writeMeta += other.writeMeta * (long)multiplier;
        this.readEvents += other.readEvents * (long)multiplier;
        this.read += other.read * (long)multiplier;
        this.readMeta += other.readMeta * (long)multiplier;
    }

    public String getTotalRated(int sessions, double period) {
        return "Sessions: " + this.numSessions + "; Sub: " + SessionStats.getRated(this.subSize, sessions) + "; SubTs: " + SessionStats.getRated(this.subTimeSeriesSize, sessions) + "; Queue: " + SessionStats.getRated(this.queueSize, sessions) + ", max " + this.maxQueueSize + "; Write: " + SessionStats.getRated(this.writeEvents, period) + " mps, " + SessionStats.getRated(this.write, period) + " pps, meta " + SessionStats.getRated(this.writeMeta, period) + " pps; Read: " + SessionStats.getRated(this.readEvents, period) + " mps, " + SessionStats.getRated(this.read, period) + " pps, meta " + SessionStats.getRated(this.readMeta, period) + " pps;";
    }

    public String getRated(double period) {
        return "Sub: " + this.subSize + "; SubTs: " + this.subTimeSeriesSize + "; Queue: " + this.queueSize + ", max " + this.maxQueueSize + "; Write: " + SessionStats.getRated(this.writeEvents, period) + " mps, " + SessionStats.getRated(this.write, period) + " pps, meta " + SessionStats.getRated(this.writeMeta, period) + " pps; Read: " + SessionStats.getRated(this.readEvents, period) + " mps, " + SessionStats.getRated(this.read, period) + " pps, meta " + SessionStats.getRated(this.readMeta, period) + " pps;";
    }

    protected void dumpStats(StringBuilder buff, double period, long currentTime) {
        buff.append(String.format("\n%30s", this.sessionId));
        if (currentTime != 0L) {
            long inactivity = currentTime - this.lastActiveTime;
            long send = currentTime - this.lastSendTime;
            buff.append(" ").append(SessionStats.periodToString(inactivity)).append("(").append(SessionStats.periodToString(send)).append(")/").append(TimePeriod.valueOf((long)(currentTime - this.createTime)));
        }
        buff.append(" - ").append(this.getRated(period));
    }

    private static String periodToString(long time) {
        return time > 10000L ? TimePeriod.valueOf((long)time).toString() : Long.toString(time);
    }

    public static double getRated(long k, double period) {
        if (k <= 0L || period <= 0.0) {
            return 0.0;
        }
        double d = (double)k / period;
        return d <= 9.99 ? Math.max(Math.floor(d * 100.0 + 0.5) / 100.0, 0.01) : (d <= 99.9 ? Math.floor(d * 10.0 + 0.5) / 10.0 : Math.floor(d + 0.5));
    }
}

