/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.rest;

import com.devexperts.logging.Logging;
import com.dxfeed.webservice.DXFeedContext;
import com.dxfeed.webservice.rest.EventsResource;
import com.dxfeed.webservice.rest.Format;
import com.dxfeed.webservice.rest.HttpErrorException;
import com.dxfeed.webservice.rest.PathInfo;
import com.dxfeed.webservice.rest.SSEConnection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EventsServlet
extends HttpServlet {
    private static final Logging log = Logging.getLogging(EventsServlet.class);
    Thread sseConnectionChecker;

    public void init() throws ServletException {
        DXFeedContext.INSTANCE.acquire();
        this.sseConnectionChecker = new Thread("SSEConnectionChecker"){

            @Override
            public void run() {
                try {
                    while (!1.interrupted()) {
                        1.sleep(SSEConnection.HEARTBEAT_PERIOD);
                        SSEConnection.checkAndHeartbeatAll();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.sseConnectionChecker.start();
    }

    public void destroy() {
        this.sseConnectionChecker.interrupt();
        DXFeedContext.INSTANCE.release();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    @Deprecated
    protected void validateSecurity(PathInfo pathInfo, HttpServletRequest request, HttpServletResponse response) throws HttpErrorException {
    }

    private void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PathInfo pathInfo;
        String path = req.getPathInfo();
        Format format = Format.getByExtension(path);
        if (format != null) {
            path = format.trimExtension(path);
        } else {
            format = Format.getByRequestMediaType(req.getHeader("Accept"));
        }
        if (path != null && path.equals("/")) {
            path = "/help";
        }
        if ((pathInfo = EventsResource.PATHS.get(path)) == null) {
            resp.sendError(404);
            return;
        }
        try {
            this.validateSecurity(pathInfo, req, resp);
            pathInfo.invokeFor(new EventsResource(req, resp, format));
        }
        catch (HttpErrorException e) {
            this.handleHttpException(e, resp);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpErrorException) {
                this.handleHttpException((HttpErrorException)cause, resp);
                return;
            }
            log.error("Error processing the resource: " + req + ", remoteAddr " + req.getRemoteAddr(), cause != null ? cause : e);
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException(cause);
        }
    }

    private void handleHttpException(HttpErrorException e, HttpServletResponse response) throws IOException {
        log.warn("HttpException: " + e.getMessage());
        if (response.isCommitted()) {
            return;
        }
        for (Map.Entry<String, String> header : e.getHeaders().entrySet()) {
            response.setHeader(header.getKey(), header.getValue());
        }
        response.sendError(e.getStatusCode(), e.getMessage());
    }
}

