/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.rest;

import com.dxfeed.webservice.DXFeedJson;
import com.dxfeed.webservice.DXFeedXml;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Format {
    XML("application/xml", ".xml"),
    JSON("application/json", ".json");

    public static final Format DEFAULT;
    public final String mediaType;
    public final String extension;

    private Format(String mediaType, String extension) {
        this.mediaType = mediaType;
        this.extension = extension;
    }

    public String trimExtension(String path) {
        if (path.endsWith(this.extension)) {
            return path.substring(0, path.length() - this.extension.length());
        }
        return path;
    }

    public void writeTo(Object result, OutputStream out, String indent) throws IOException {
        switch (this) {
            case XML: {
                DXFeedXml.writeTo(result, out, indent);
                break;
            }
            case JSON: {
                DXFeedJson.writeTo(result, out, indent);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public Object readFrom(InputStream in, Class valueType) throws IOException {
        switch (this) {
            case XML: {
                return DXFeedXml.readFrom(in);
            }
            case JSON: {
                return DXFeedJson.readFrom(in, valueType);
            }
        }
        throw new AssertionError();
    }

    @Nullable
    public static Format getByExtension(@Nullable String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(Format.XML.extension)) {
            return XML;
        }
        if (path.endsWith(Format.JSON.extension)) {
            return JSON;
        }
        return null;
    }

    @Nonnull
    public static Format getByRequestMediaType(@Nullable String requestMediaType) {
        if (requestMediaType == null || requestMediaType.isEmpty()) {
            return DEFAULT;
        }
        StringTokenizer st = new StringTokenizer(requestMediaType, ",");
        while (st.hasMoreTokens()) {
            Format format = Format.getByMediaType(st.nextToken());
            if (format == null) continue;
            return format;
        }
        return DEFAULT;
    }

    @Nullable
    private static Format getByMediaType(String mediaType) {
        if (mediaType.equals(Format.XML.mediaType)) {
            return XML;
        }
        if (mediaType.equals(Format.JSON.mediaType)) {
            return JSON;
        }
        return null;
    }

    static {
        DEFAULT = XML;
    }
}

