/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.rest;

import com.devexperts.logging.Logging;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.SynchronizedIndexedSet;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import com.dxfeed.webservice.rest.EventsServlet;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;

public abstract class SSEConnection
implements AsyncListener,
Serializable {
    protected final Logging log = Logging.getLogging(this.getClass());
    private static final long serialVersionUID = 0L;
    public static final long HEARTBEAT_PERIOD = TimePeriod.valueOf((String)SystemProperties.getProperty(EventsServlet.class, (String)"heartbeatPeriod", (String)"10s")).getTime();
    private static final IndexedSet<SSEConnection, SSEConnection> CONNECTIONS = new SynchronizedIndexedSet();
    private static final AtomicLong CONNECTION_ID = new AtomicLong();
    public static final String CONTENT_TYPE = "text/event-stream";
    private static final byte[] LINE_START = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte LINE_END = 10;
    private static final byte MESSAGE_END = 10;
    protected final long id = CONNECTION_ID.incrementAndGet();
    @GuardedBy(value="this")
    protected volatile transient boolean active;
    @GuardedBy(value="this")
    protected transient Output out;
    @GuardedBy(value="this")
    protected transient AsyncContext async;
    protected volatile transient long lastMessageTime;

    protected SSEConnection() {
    }

    public boolean isActive() {
        return this.active;
    }

    protected synchronized boolean start(AsyncContext async) throws IOException {
        boolean wasActive = this.active;
        this.stopSync();
        this.active = true;
        ServletResponse resp = async.getResponse();
        resp.setContentType(CONTENT_TYPE);
        resp.flushBuffer();
        this.async = async;
        this.out = new Output((OutputStream)resp.getOutputStream());
        CONNECTIONS.add((Object)this);
        async.setTimeout(0L);
        async.addListener((AsyncListener)this);
        this.startImpl();
        return wasActive;
    }

    protected boolean stop() {
        if (!this.active) {
            return false;
        }
        return this.stopSync();
    }

    private synchronized boolean stopSync() {
        if (!this.active) {
            return false;
        }
        this.active = false;
        CONNECTIONS.remove((Object)this);
        this.stopImpl();
        this.async.complete();
        this.async = null;
        this.out = null;
        return true;
    }

    public void heartbeat() {
        if (System.currentTimeMillis() >= this.lastMessageTime + HEARTBEAT_PERIOD) {
            this.heartbeatImpl();
        }
    }

    @GuardedBy(value="this")
    protected abstract void startImpl();

    @GuardedBy(value="this")
    protected abstract void stopImpl();

    protected abstract void heartbeatImpl();

    public void onComplete(AsyncEvent event) throws IOException {
        if (this.stop()) {
            this.log.info("Stopped, because of onComplete " + this);
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        if (this.stop()) {
            this.log.info("Stopped, because of onTimeout " + this);
        }
    }

    public void onError(AsyncEvent event) throws IOException {
        if (this.stop()) {
            this.log.info("Stopped, because of onError " + this);
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public static void checkAndHeartbeatAll() {
        Iterator it = CONNECTIONS.concurrentIterator();
        while (it.hasNext()) {
            ((SSEConnection)it.next()).heartbeat();
        }
    }

    protected class Output
    extends FilterOutputStream {
        boolean inLine;
        boolean crSeen;

        Output(OutputStream out) {
            super(out);
        }

        private void startLine() throws IOException {
            if (!this.inLine) {
                this.inLine = true;
                super.write(LINE_START);
            }
        }

        private void endLine() throws IOException {
            if (this.inLine) {
                this.inLine = false;
                super.write(10);
            }
        }

        @Override
        public void write(int b) throws IOException {
            switch (b) {
                case 13: {
                    this.crSeen = true;
                    this.startLine();
                    this.endLine();
                    break;
                }
                case 10: {
                    if (this.crSeen) {
                        this.crSeen = false;
                        break;
                    }
                    this.startLine();
                    this.endLine();
                    break;
                }
                default: {
                    this.crSeen = false;
                    this.startLine();
                    super.write(b);
                }
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public void endMessage() throws IOException {
            this.endLine();
            super.write(10);
            super.flush();
            SSEConnection.this.lastMessageTime = System.currentTimeMillis();
        }
    }
}

