/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import com.devexperts.io.MarshallingException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class MarshalledTest {
    private static final byte[] SMALL_BYTE_ARRAY = "Some random bytes here".getBytes();
    private static final byte[] LARGE_BYTE_ARRAY = new byte[1500];
    private static final Class<?>[] TYPES = new Class[]{Void.class, Integer.class, int[].class, Object.class};
    public static final int BIG_SIZE = 1000000;

    @Test
    public void testMarshalledError() {
        Assert.assertThrows(MarshallingException.class, () -> {
            Object[] cfr_ignored_0 = (Object[])Marshalled.forBytes((byte[])SMALL_BYTE_ARRAY, (Marshaller)Marshaller.forClasses((Class[])TYPES)).getObject();
        });
        Assert.assertThrows(MarshallingException.class, () -> {
            Object[] cfr_ignored_0 = (Object[])Marshalled.forBytes((byte[])LARGE_BYTE_ARRAY, (Marshaller)Marshaller.forClasses((Class[])TYPES)).getObject();
        });
        Assert.assertThrows(MarshallingException.class, () -> Marshalled.forBytes((byte[])SMALL_BYTE_ARRAY).getObject());
        Assert.assertThrows(MarshallingException.class, () -> Marshalled.forBytes((byte[])LARGE_BYTE_ARRAY).getObject());
    }

    @Test
    public void testNullObject() {
        Assert.assertNotNull((Object)Marshalled.NULL);
        Assert.assertNull((Object)Marshalled.NULL.getBytes());
        Assert.assertNull((Object)Marshalled.NULL.getObject());
        Assert.assertSame((Object)Marshalled.NULL, (Object)Marshalled.forObject(null));
        Assert.assertSame((Object)Marshalled.NULL, (Object)Marshalled.forObject(null, (Marshaller)Marshaller.SERIALIZATION));
        Assert.assertSame((Object)Marshalled.NULL, (Object)Marshalled.forBytes(null));
        Assert.assertSame((Object)Marshalled.NULL, (Object)Marshalled.forBytes(null, (Marshaller)Marshaller.SERIALIZATION));
    }

    @Test
    public void testSerialization() {
        Marshalled oneFromObject = Marshalled.forObject((Object)1);
        Assert.assertEquals((Object)1, (Object)oneFromObject.getObject());
        byte[] oneBytes = oneFromObject.getBytes();
        Marshalled oneFromBytes = Marshalled.forBytes((byte[])oneBytes);
        Assert.assertEquals((Object)1, (Object)oneFromBytes.getObject());
        Assert.assertArrayEquals((byte[])oneBytes, (byte[])oneFromBytes.getBytes());
        Assert.assertEquals((Object)oneFromBytes, (Object)oneFromObject);
        Assert.assertEquals((long)oneFromBytes.hashCode(), (long)oneFromObject.hashCode());
        Assert.assertEquals((Object)oneFromBytes.toString(), (Object)oneFromObject.toString());
    }

    public static long getUsed() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    @Test
    public void testMemoryDuplication() {
        long[] allocations = new long[20];
        Marshalled original = Marshalled.forObject((Object)new BigObject());
        for (int i = 0; i < allocations.length; ++i) {
            long used = MarshalledTest.getUsed();
            long time = System.currentTimeMillis();
            BigObject result = (BigObject)Marshalled.forBytes((byte[])original.getBytes()).getObject();
            allocations[i] = result.used - used;
        }
        Arrays.sort(allocations);
        Assert.assertTrue((String)"deserialization allocates too much memory", (allocations[allocations.length / 2] < 1000000L ? 1 : 0) != 0);
    }

    static {
        for (int i = 0; i < LARGE_BYTE_ARRAY.length; ++i) {
            MarshalledTest.LARGE_BYTE_ARRAY[i] = SMALL_BYTE_ARRAY[i % SMALL_BYTE_ARRAY.length];
        }
    }

    public static class BigObject
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public transient long used;

        private void writeObject(ObjectOutputStream out) throws IOException {
            for (int i = 0; i < 250000; ++i) {
                out.writeInt(i);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.used = MarshalledTest.getUsed();
            for (int i = 0; i < 250000; ++i) {
                Assert.assertEquals((long)i, (long)in.readInt());
            }
        }
    }
}

