/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.FastDoubleUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.function.ToDoubleFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class FastDoubleUtilTest {
    private static final int RANDOM_GENERATED_NUMBERS = 1000;
    private static final String[] FULL_PRECISION_FORMATS = new String[]{"%.0f", "%.2f", "%.5f", "%.10f", "%.14f", "%.17f"};

    @Test
    public void parseDoubleSpecialCasesTest() {
        Assert.assertTrue((boolean)this.compare(0.0, FastDoubleUtil.parseDouble((CharSequence)"0.0")));
        Assert.assertTrue((boolean)this.compare(-0.0, FastDoubleUtil.parseDouble((CharSequence)"-0.0")));
        Assert.assertTrue((boolean)this.compare(-0.0, FastDoubleUtil.parseDouble((CharSequence)"-.0")));
        Assert.assertTrue((boolean)this.compare(0.0, FastDoubleUtil.parseDouble((CharSequence)"0.")));
        Assert.assertTrue((boolean)this.compare(0.0, FastDoubleUtil.parseDouble((CharSequence)"+0")));
        Assert.assertTrue((boolean)this.compare(-0.0, FastDoubleUtil.parseDouble((CharSequence)"-0")));
        Assert.assertTrue((boolean)this.compare(0.0, FastDoubleUtil.parseDouble((CharSequence)"+0.0e-10")));
        Assert.assertTrue((boolean)this.compare(-0.0, FastDoubleUtil.parseDouble((CharSequence)"-0.0E-3")));
        Assert.assertTrue((boolean)this.compare(0.0, FastDoubleUtil.parseDouble((CharSequence)"+0.0e15")));
        Assert.assertTrue((boolean)this.compare(0.5, FastDoubleUtil.parseDouble((CharSequence)".5e0")));
        Assert.assertTrue((boolean)this.compare(123.0, FastDoubleUtil.parseDouble((CharSequence)"123.")));
        Assert.assertTrue((boolean)this.compare(Double.NaN, FastDoubleUtil.parseDouble((CharSequence)"NaN")));
        Assert.assertTrue((boolean)this.compare(Double.NEGATIVE_INFINITY, FastDoubleUtil.parseDouble((CharSequence)"-Infinity")));
        Assert.assertTrue((boolean)this.compare(Double.POSITIVE_INFINITY, FastDoubleUtil.parseDouble((CharSequence)"+Infinity")));
        Assert.assertTrue((boolean)this.compare(Double.POSITIVE_INFINITY, FastDoubleUtil.parseDouble((CharSequence)"Infinity")));
        Assert.assertTrue((boolean)this.compare(Double.MAX_VALUE, FastDoubleUtil.parseDouble((CharSequence)Double.toString(Double.MAX_VALUE))));
        Assert.assertTrue((boolean)this.compare(Double.MIN_NORMAL, FastDoubleUtil.parseDouble((CharSequence)Double.toString(Double.MIN_NORMAL))));
        Assert.assertTrue((boolean)this.compare(Double.MIN_VALUE, FastDoubleUtil.parseDouble((CharSequence)Double.toString(Double.MIN_VALUE))));
        Assert.assertTrue((boolean)this.compare(Double.POSITIVE_INFINITY, FastDoubleUtil.parseDouble((CharSequence)"1e+310")));
        Assert.assertTrue((boolean)this.compare(Double.NEGATIVE_INFINITY, FastDoubleUtil.parseDouble((CharSequence)"-1e+309")));
        Assert.assertTrue((boolean)this.compare(-0.0, FastDoubleUtil.parseDouble((CharSequence)"-1e-325")));
        Assert.assertTrue((boolean)this.compare(0.0, FastDoubleUtil.parseDouble((CharSequence)"1e-325")));
        Assert.assertTrue((boolean)this.compare(-0.0, FastDoubleUtil.parseDouble((CharSequence)"-1e-333")));
        Assert.assertTrue((boolean)this.compare(0.0, FastDoubleUtil.parseDouble((CharSequence)"1e-333")));
        Assert.assertTrue((boolean)this.compare(Double.NEGATIVE_INFINITY, FastDoubleUtil.parseDouble((CharSequence)"-1E10000000000000000000000")));
        Assert.assertTrue((boolean)this.compare(Double.POSITIVE_INFINITY, FastDoubleUtil.parseDouble((CharSequence)"1E100000000000000000000000")));
        String strPi = "3.14159265358979323846264338327950288";
        Assert.assertTrue((boolean)this.compare(Double.parseDouble(strPi), FastDoubleUtil.parseDouble((CharSequence)strPi)));
        String strE = "2.7182818284590452353602874713527";
        Assert.assertTrue((boolean)this.compare(Double.parseDouble(strE), FastDoubleUtil.parseDouble((CharSequence)strE)));
        String strSqrt2 = "1.41421356237309504880168872420969808";
        Assert.assertTrue((boolean)this.compare(Double.parseDouble(strSqrt2), FastDoubleUtil.parseDouble((CharSequence)strSqrt2)));
        String strFi = "1.61803398874989484820458683436563812";
        Assert.assertTrue((boolean)this.compare(Double.parseDouble(strFi), FastDoubleUtil.parseDouble((CharSequence)strFi)));
        String strH = "0.00000000000000000000000000000000062607015";
        Assert.assertTrue((boolean)this.compare(Double.parseDouble(strH), FastDoubleUtil.parseDouble((CharSequence)strH)));
        String strNa = "602214085774000000000000";
        Assert.assertTrue((boolean)this.compare(Double.parseDouble(strNa), FastDoubleUtil.parseDouble((CharSequence)strNa)));
    }

    @Test
    public void parseDoubleSpecialExceptions() {
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)""));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"-"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"-."));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"."));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)".e1"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"-E1"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"\u00af|_(\u30c4)_/\u00af"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"1.2.3"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"1.E2Y3"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"1234567\u00af|_(\u30c4)_/\u00af"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"INF\u00af|_(\u30c4)_/\u00af"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"N\u00af|_(\u30c4)_/\u00af"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"NXX"));
        Assert.assertThrows(NumberFormatException.class, () -> FastDoubleUtil.parseDouble((CharSequence)"1E10000X"));
    }

    @Test
    public void parseDoubleWithExponentTest() {
        this.generateValuesWithExponent().forEach(this::parseDoubles);
    }

    @Test
    public void parseDoubleWithoutExponentTest() {
        this.generateValuesWithoutExponent(1.0E-7, 1.0E-5).forEach(this::parseDoubles);
        this.generateValuesWithoutExponent(1.0E-6, 1.0E-4).forEach(this::parseDoubles);
        this.generateValuesWithoutExponent(1.0E-4, 0.001).forEach(this::parseDoubles);
        this.generateValuesWithoutExponent(0.01, 0.1).forEach(this::parseDoubles);
        this.generateValuesWithoutExponent(1.0, 100.0).forEach(this::parseDoubles);
        this.generateValuesWithoutExponent(100.0, 10000.0).forEach(this::parseDoubles);
        this.generateValuesWithoutExponent(10000.0, 1000000.0).forEach(this::parseDoubles);
        this.generateValuesWithoutExponent(1000000.0, 1.0E8).forEach(this::parseDoubles);
    }

    @Test
    public void formatDoubleMaxPrecisionTest() {
        Assert.assertEquals((Object)"-0", (Object)FastDoubleUtilTest.formatPrecision(-0.0));
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatPrecision(0.0));
        Assert.assertEquals((Object)"NaN", (Object)FastDoubleUtilTest.formatPrecision(Double.NaN));
        Assert.assertEquals((Object)"-Infinity", (Object)FastDoubleUtilTest.formatPrecision(Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)"Infinity", (Object)FastDoubleUtilTest.formatPrecision(Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"Infinity", (Object)FastDoubleUtilTest.formatPrecision(Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"9.999999999999999E22", (Object)FastDoubleUtilTest.formatPrecision(1.0E23));
        Assert.assertEquals((Object)"9.999999999999999E22", (Object)FastDoubleUtilTest.formatPrecision(1.0E23));
        Assert.assertEquals((Object)"0.000000001", (Object)FastDoubleUtilTest.formatPrecision(1.0E-9));
        Assert.assertEquals((Object)"1000000000", (Object)FastDoubleUtilTest.formatPrecision(1.0E9));
        Assert.assertEquals((Object)"0.00000000123456789", (Object)FastDoubleUtilTest.formatPrecision(1.23456789E-9));
        Assert.assertEquals((Object)"1234567890", (Object)FastDoubleUtilTest.formatPrecision(1.23456789E9));
        Assert.assertEquals((Object)"9999999999", (Object)FastDoubleUtilTest.formatPrecision(9.999999999E9));
        Assert.assertEquals((Object)"9.9999999E-10", (Object)FastDoubleUtilTest.formatPrecision(9.9999999E-10));
        Assert.assertEquals((Object)"9.99999999999999E16", (Object)FastDoubleUtilTest.formatPrecision(9.99999999999999E16));
        Assert.assertEquals((Object)"1E-10", (Object)FastDoubleUtilTest.formatPrecision(1.0E-10));
        Assert.assertEquals((Object)"1E10", (Object)FastDoubleUtilTest.formatPrecision(1.0E10));
        Assert.assertEquals((Object)Double.toString(Double.MAX_VALUE), (Object)FastDoubleUtilTest.formatPrecision(Double.MAX_VALUE));
        Assert.assertEquals((Object)Double.toString(Double.MIN_NORMAL), (Object)FastDoubleUtilTest.formatPrecision(Double.MIN_NORMAL));
        Assert.assertEquals((Object)Double.toString(Double.MIN_VALUE), (Object)FastDoubleUtilTest.formatPrecision(Double.MIN_VALUE));
        Assert.assertThrows(IllegalArgumentException.class, () -> FastDoubleUtil.formatDoublePrecision((double)1.0E10, (int)-1));
    }

    @Test
    public void formatDoublePrecisionTest() {
        Assert.assertEquals((Object)"0.00000000123", (Object)FastDoubleUtilTest.formatPrecision(1.23456789E-9, 3));
        Assert.assertEquals((Object)"1235000000", (Object)FastDoubleUtilTest.formatPrecision(1.23456789E9, 4));
        Assert.assertEquals((Object)"10000000000", (Object)FastDoubleUtilTest.formatPrecision(9.999999999E9, 3));
        Assert.assertEquals((Object)"9.9999999E-10", (Object)FastDoubleUtilTest.formatPrecision(9.9999999E-10));
        Assert.assertEquals((Object)"1E23", (Object)FastDoubleUtilTest.formatPrecision(1.0E23, 15));
        Assert.assertEquals((Object)"1E23", (Object)FastDoubleUtilTest.formatPrecision(1.0E23, 15));
        Assert.assertEquals((Object)"1E17", (Object)FastDoubleUtilTest.formatPrecision(9.999999999999998E16, 15));
        Assert.assertEquals((Object)"0.00001", (Object)FastDoubleUtilTest.formatPrecision(9.999999999999999E-6, 15));
        Assert.assertEquals((Object)"0.3", (Object)FastDoubleUtilTest.formatPrecision(0.30000000000000004, 15));
    }

    @Test
    public void formatDoubleNotationFormatTest() {
        Assert.assertEquals((Object)"0.00000000123", (Object)FastDoubleUtilTest.formatPrecision(1.23456789E-9, 3));
        Assert.assertEquals((Object)"1235000000", (Object)FastDoubleUtilTest.formatPrecision(1.23456789E9, 4));
        Assert.assertEquals((Object)"10000000000", (Object)FastDoubleUtilTest.formatPrecision(9.999999999E9, 3));
        Assert.assertEquals((Object)"9.9999999E-10", (Object)FastDoubleUtilTest.formatPrecision(9.9999999E-10, 15));
        Assert.assertEquals((Object)"1E-9", (Object)FastDoubleUtilTest.formatPrecision(9.9999999E-10, 7));
        Assert.assertEquals((Object)"1E17", (Object)FastDoubleUtilTest.formatPrecision(9.999999999999998E16, 15));
        Assert.assertEquals((Object)"0.00001", (Object)FastDoubleUtilTest.formatPrecision(9.999999999999999E-6, 15));
        Assert.assertEquals((Object)"0.3", (Object)FastDoubleUtilTest.formatPrecision(0.30000000000000004, 15));
    }

    @Test
    public void formatEngineeringDouble() {
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatPrecision(0.0));
        Assert.assertEquals((Object)"0.1", (Object)FastDoubleUtilTest.formatPrecision(0.1));
        Assert.assertEquals((Object)"0.01", (Object)FastDoubleUtilTest.formatPrecision(0.01));
        Assert.assertEquals((Object)"0.001", (Object)FastDoubleUtilTest.formatPrecision(0.001));
        Assert.assertEquals((Object)"0.0001", (Object)FastDoubleUtilTest.formatPrecision(1.0E-4));
        Assert.assertEquals((Object)"0.00001", (Object)FastDoubleUtilTest.formatPrecision(1.0E-5));
        Assert.assertEquals((Object)"0.000001", (Object)FastDoubleUtilTest.formatPrecision(1.0E-6));
        Assert.assertEquals((Object)"0.0000001", (Object)FastDoubleUtilTest.formatPrecision(1.0E-7));
        Assert.assertEquals((Object)"0.00000001", (Object)FastDoubleUtilTest.formatPrecision(1.0E-8));
        Assert.assertEquals((Object)"0.000000001", (Object)FastDoubleUtilTest.formatPrecision(1.0E-9));
        Assert.assertEquals((Object)"1E-10", (Object)FastDoubleUtilTest.formatPrecision(1.0E-10));
    }

    @Test
    public void formatScientificDouble() {
        Assert.assertEquals((Object)"1", (Object)FastDoubleUtilTest.formatPrecision(1.0));
        Assert.assertEquals((Object)"10", (Object)FastDoubleUtilTest.formatPrecision(10.0));
        Assert.assertEquals((Object)"100", (Object)FastDoubleUtilTest.formatPrecision(100.0));
        Assert.assertEquals((Object)"1000", (Object)FastDoubleUtilTest.formatPrecision(1000.0));
        Assert.assertEquals((Object)"10000", (Object)FastDoubleUtilTest.formatPrecision(10000.0));
        Assert.assertEquals((Object)"100000", (Object)FastDoubleUtilTest.formatPrecision(100000.0));
        Assert.assertEquals((Object)"1000000", (Object)FastDoubleUtilTest.formatPrecision(1000000.0));
        Assert.assertEquals((Object)"10000000", (Object)FastDoubleUtilTest.formatPrecision(1.0E7));
        Assert.assertEquals((Object)"100000000", (Object)FastDoubleUtilTest.formatPrecision(1.0E8));
        Assert.assertEquals((Object)"1000000000", (Object)FastDoubleUtilTest.formatPrecision(1.0E9));
        Assert.assertEquals((Object)"1E10", (Object)FastDoubleUtilTest.formatPrecision(1.0E10));
    }

    @Test
    public void formatDoubleScaleSpecialCasesTest() {
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatScale(-0.0, 0));
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatScale(0.0, 0));
        Assert.assertEquals((Object)"NaN", (Object)FastDoubleUtilTest.formatScale(Double.NaN, 0));
        Assert.assertEquals((Object)"-Infinity", (Object)FastDoubleUtilTest.formatScale(Double.NEGATIVE_INFINITY, 0));
        Assert.assertEquals((Object)"Infinity", (Object)FastDoubleUtilTest.formatScale(Double.POSITIVE_INFINITY, 0));
        Assert.assertEquals((Object)"9.999999999999999E22", (Object)FastDoubleUtilTest.formatScale(1.0E23, 0));
        Assert.assertEquals((Object)"9.999999999999999E22", (Object)FastDoubleUtilTest.formatScale(1.0E23, 0));
        Assert.assertEquals((Object)"0.000000001", (Object)FastDoubleUtilTest.formatScale(1.0E-9, 9));
        Assert.assertEquals((Object)"1000000000", (Object)FastDoubleUtilTest.formatScale(1.0E9, 0));
        Assert.assertEquals((Object)"0.00000000123456789", (Object)FastDoubleUtilTest.formatScale(1.23456789E-9, 17));
        Assert.assertEquals((Object)"1234567890", (Object)FastDoubleUtilTest.formatScale(1.23456789E9, 10));
        Assert.assertEquals((Object)"0.3", (Object)FastDoubleUtilTest.formatScale(0.30000000000000004, 16));
        Assert.assertEquals((Object)"0.30000000000000004", (Object)FastDoubleUtilTest.formatScale(0.30000000000000004, 17));
        Assert.assertEquals((Object)"1E-14", (Object)FastDoubleUtilTest.formatScale(6.0E-15, 14));
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatScale(-0.3, 0));
        Assert.assertEquals((Object)Double.toString(Double.MAX_VALUE), (Object)FastDoubleUtilTest.formatScale(Double.MAX_VALUE, Integer.MAX_VALUE));
        Assert.assertEquals((Object)Double.toString(Double.MIN_NORMAL), (Object)FastDoubleUtilTest.formatScale(Double.MIN_NORMAL, Integer.MAX_VALUE));
        Assert.assertEquals((Object)Double.toString(Double.MIN_VALUE), (Object)FastDoubleUtilTest.formatScale(Double.MIN_VALUE, Integer.MAX_VALUE));
    }

    @Test
    public void formatDoubleNegativeScaleTest() {
        Assert.assertEquals((Object)"123456789", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, 0));
        Assert.assertEquals((Object)"123456790", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -1));
        Assert.assertEquals((Object)"123456800", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -2));
        Assert.assertEquals((Object)"123457000", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -3));
        Assert.assertEquals((Object)"123460000", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -4));
        Assert.assertEquals((Object)"123500000", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -5));
        Assert.assertEquals((Object)"123000000", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -6));
        Assert.assertEquals((Object)"120000000", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -7));
        Assert.assertEquals((Object)"100000000", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -8));
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -9));
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatScale(1.2345678912345E8, -100));
        Assert.assertEquals((Object)"1.23456789E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, 0));
        Assert.assertEquals((Object)"1.23456789E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -1));
        Assert.assertEquals((Object)"1.2345679E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -35));
        Assert.assertEquals((Object)"1.234568E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -36));
        Assert.assertEquals((Object)"1.23457E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -37));
        Assert.assertEquals((Object)"1.2346E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -38));
        Assert.assertEquals((Object)"1.235E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -39));
        Assert.assertEquals((Object)"1.23E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -40));
        Assert.assertEquals((Object)"1.2E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -41));
        Assert.assertEquals((Object)"1E42", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -42));
        Assert.assertEquals((Object)"0", (Object)FastDoubleUtilTest.formatScale(1.23456789E42, -43));
    }

    @Test
    public void formatDoubleScaleFractionTest() {
        Random rnd = new Random();
        IntStream.rangeClosed(0, 42).forEach(scale -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "+" : "-") + rnd.nextInt(42)).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    double bigDecimalDouble;
                    String strScale = FastDoubleUtilTest.formatScale(value, scale);
                    String strBigDecimal = BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP).toString();
                    double scaleDouble = Double.parseDouble(strScale);
                    if (!this.compare(scaleDouble, bigDecimalDouble = Double.parseDouble(strBigDecimal))) {
                        Assert.fail((String)("Incorrect scale: " + value + ", result: " + scaleDouble + " jdk: " + bigDecimalDouble + ", scale: " + scale));
                    }
                });
            }
        });
    }

    @Test
    public void formatDoubleScaleIntegerTest() {
        Random rnd = new Random();
        IntStream.range(-18, 0).forEach(scale -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E+" + rnd.nextInt(16)).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    double bigDecimalDouble;
                    String strScale = FastDoubleUtilTest.formatScale(value, scale);
                    String strBigDecimal = BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP).toString();
                    double scaleDouble = Double.parseDouble(strScale);
                    if (!this.compare(scaleDouble, bigDecimalDouble = Double.parseDouble(strBigDecimal))) {
                        Assert.fail((String)("Incorrect scale: " + value + ", result: " + scaleDouble + ", jdk: " + bigDecimalDouble + ", scale: " + scale));
                    }
                });
            }
        });
    }

    @Test
    public void formatDoubleScaleApproximateIntegerTest() {
        Random rnd = new Random();
        IntStream.range(-20, 0).forEach(scale -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E+" + rnd.nextInt(308)).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    String strScale = FastDoubleUtilTest.formatScale(value, scale);
                    BigDecimal decimal = BigDecimal.valueOf(value);
                    String strBigDecimalUp = decimal.setScale(scale, RoundingMode.UP).toString();
                    String strBigDecimalDown = decimal.setScale(scale, RoundingMode.DOWN).toString();
                    double scaleDouble = Double.parseDouble(strScale);
                    double bigDecimalDoubleUp = Double.parseDouble(strBigDecimalUp);
                    double bigDecimalDoubleDown = Double.parseDouble(strBigDecimalDown);
                    if (!this.compare(scaleDouble, bigDecimalDoubleUp) && !this.compare(scaleDouble, bigDecimalDoubleDown)) {
                        Assert.fail((String)("Incorrect scale: " + value + ", result: " + scaleDouble + ", bigDecimalDoubleUp: " + bigDecimalDoubleUp + ", bigDecimalDoubleDown: " + bigDecimalDoubleDown + ", scale: " + scale));
                    }
                });
            }
        });
    }

    @Test
    public void formatDoubleStrictRoundingTest() {
        Random rnd = new Random();
        IntStream.rangeClosed(1, 16).forEach(round -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "+" + rnd.nextInt(16) : "-" + rnd.nextInt(308))).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    double jdkDouble;
                    String fast = FastDoubleUtilTest.formatPrecision(value, round);
                    String jdk = BigDecimal.valueOf(value).round(new MathContext(round, RoundingMode.HALF_UP)).toString();
                    double fastDouble = Double.parseDouble(fast);
                    if (!this.compare(fastDouble, jdkDouble = Double.parseDouble(jdk))) {
                        Assert.fail((String)("Incorrect format:" + value + ", util: " + fastDouble + ", jdk: " + jdkDouble + ", round: " + round));
                    }
                });
            }
        });
    }

    @Test
    public void formatDoubleApproximationRoundingTest() {
        Random rnd = new Random();
        IntStream.rangeClosed(1, 16).forEach(round -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "+" + rnd.nextInt(307) : "-" + rnd.nextInt(320))).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    String fast = FastDoubleUtilTest.formatPrecision(value, round);
                    String jdkUp = BigDecimal.valueOf(value).round(new MathContext(round, RoundingMode.UP)).toString();
                    String jdkDown = BigDecimal.valueOf(value).round(new MathContext(round, RoundingMode.DOWN)).toString();
                    double fastDouble = Double.parseDouble(fast);
                    double jdkDoubleUp = Double.parseDouble(jdkUp);
                    double jdkDoubleDown = Double.parseDouble(jdkDown);
                    if (!this.compare(fastDouble, jdkDoubleUp) && !this.compare(fastDouble, jdkDoubleDown)) {
                        Assert.fail((String)("Incorrect format:" + value + ", util: " + fastDouble + ", jdk: " + jdkDoubleUp + "/" + jdkDoubleDown + ", round: " + round));
                    }
                });
            }
        });
    }

    @Test
    public void roundScaleSpecialCasesTest() {
        Assert.assertTrue((boolean)this.compare(0.0, this.roundScale(-0.0, 0, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(0.0, this.roundScale(0.0, 0, RoundingMode.CEILING)));
        Assert.assertTrue((boolean)Double.isNaN(this.roundScale(Double.NaN, 0, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(Double.NEGATIVE_INFINITY, this.roundScale(Double.NEGATIVE_INFINITY, 0, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(Double.POSITIVE_INFINITY, this.roundScale(Double.POSITIVE_INFINITY, 0, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.0E23, this.roundScale(1.0E23, 0, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.234568E-9, this.roundScale(1.2345675E-9, 15, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.234567E-9, this.roundScale(1.2345675E-9, 15, RoundingMode.HALF_DOWN)));
        Assert.assertTrue((boolean)this.compare(1.234568E-9, this.roundScale(1.2345675E-9, 15, RoundingMode.HALF_EVEN)));
        Assert.assertTrue((boolean)this.compare(1.2345679E9, this.roundScale(1.23456789E9, -2, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.2345678E9, this.roundScale(1.23456789E9, -2, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(0.3, this.roundScale(0.30000000000000004, 16, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(0.3, this.roundScale(0.30000000000000004, 16, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(0.30000000000000004, this.roundScale(0.30000000000000004, 17, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(0.3000000000000001, this.roundScale(0.30000000000000004, 16, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(0.3, this.roundScale(0.30000000000000004, 16, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(0.1, this.roundScale(0.06, 1, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(0.0, this.roundScale(0.06, 1, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1235.0, this.roundScale(1234.5, 0, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.3E-5, this.roundScale(1.2345E-5, 6, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(-10000.0, this.roundScale(-100.0, -4, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.0E20, this.roundScale(1.23456789E8, -20, RoundingMode.CEILING)));
    }

    @Test
    public void roundNegativeScaleTest() {
        Assert.assertTrue((boolean)this.compare(1.23456789E8, this.roundScale(1.2345678912345E8, 0, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.23456789E8, this.roundScale(1.2345678912345E8, 0, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.2345679E8, this.roundScale(1.2345678912345E8, 0, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.2345679E8, this.roundScale(1.2345678912345E8, -1, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.2345678E8, this.roundScale(1.2345678912345E8, -1, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.2345679E8, this.roundScale(1.2345678912345E8, -1, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.234568E8, this.roundScale(1.2345678912345E8, -2, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.234567E8, this.roundScale(1.2345678912345E8, -2, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.234568E8, this.roundScale(1.2345678912345E8, -2, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.23457E8, this.roundScale(1.2345678912345E8, -3, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.23456E8, this.roundScale(1.2345678912345E8, -3, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.23457E8, this.roundScale(1.2345678912345E8, -3, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.2346E8, this.roundScale(1.2345678912345E8, -4, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.2345E8, this.roundScale(1.2345678912345E8, -4, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.2346E8, this.roundScale(1.2345678912345E8, -4, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.235E8, this.roundScale(1.2345678912345E8, -5, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.234E8, this.roundScale(1.2345678912345E8, -5, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.235E8, this.roundScale(1.2345678912345E8, -5, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.23E8, this.roundScale(1.2345678912345E8, -6, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.23E8, this.roundScale(1.2345678912345E8, -6, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.24E8, this.roundScale(1.2345678912345E8, -6, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.2E8, this.roundScale(1.2345678912345E8, -7, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.2E8, this.roundScale(1.2345678912345E8, -7, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.3E8, this.roundScale(1.2345678912345E8, -7, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(1.0E8, this.roundScale(1.2345678912345E8, -8, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(1.0E8, this.roundScale(1.2345678912345E8, -8, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(2.0E8, this.roundScale(1.2345678912345E8, -8, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(0.0, this.roundScale(1.2345678912345E8, -9, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(0.0, this.roundScale(1.2345678912345E8, -9, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.0E9, this.roundScale(1.2345678912345E8, -9, RoundingMode.UP)));
        Assert.assertTrue((boolean)this.compare(0.0, this.roundScale(1.2345678912345E8, -100, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(0.0, this.roundScale(1.2345678912345E8, -100, RoundingMode.DOWN)));
        Assert.assertTrue((boolean)this.compare(1.0E100, this.roundScale(1.2345678912345E8, -100, RoundingMode.UP)));
    }

    @Test
    public void roundScaleFractionTest() {
        Random rnd = new Random();
        IntStream.rangeClosed(0, 42).forEach(scale -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "+" : "-") + rnd.nextInt(42)).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    double halfUp = this.roundScale((double)value, scale, RoundingMode.HALF_UP);
                    double halfDown = this.roundScale((double)value, scale, RoundingMode.HALF_DOWN);
                    double halfEven = this.roundScale((double)value, scale, RoundingMode.HALF_EVEN);
                    double ceiling = this.roundScale((double)value, scale, RoundingMode.CEILING);
                    double floor = this.roundScale((double)value, scale, RoundingMode.FLOOR);
                    double up = this.roundScale((double)value, scale, RoundingMode.UP);
                    double down = this.roundScale((double)value, scale, RoundingMode.DOWN);
                    BigDecimal decimal = BigDecimal.valueOf(value);
                    double jdkHalfUp = decimal.setScale(scale, RoundingMode.HALF_UP).doubleValue();
                    double jdkHalfDown = decimal.setScale(scale, RoundingMode.HALF_DOWN).doubleValue();
                    double jdkHalfEven = decimal.setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
                    double jdkCeiling = decimal.setScale(scale, RoundingMode.CEILING).doubleValue();
                    double jdkFloor = decimal.setScale(scale, RoundingMode.FLOOR).doubleValue();
                    double jdkUp = decimal.setScale(scale, RoundingMode.UP).doubleValue();
                    double jdkDown = decimal.setScale(scale, RoundingMode.DOWN).doubleValue();
                    if (!this.compare(halfUp, jdkHalfUp)) {
                        Assert.fail((String)("Incorrect halfUp: " + value + ", result: " + halfUp + ", jdkHalfUp: " + jdkHalfUp + ", scale: " + scale));
                    }
                    if (!this.compare(halfDown, jdkHalfDown)) {
                        Assert.fail((String)("Incorrect halfDown: " + value + ", result: " + halfDown + ", jdkHalfDown: " + jdkHalfDown + ", scale: " + scale));
                    }
                    if (!this.compare(halfEven, jdkHalfEven)) {
                        Assert.fail((String)("Incorrect halfEven: " + value + ", result: " + halfEven + ", jdkHalfEven: " + jdkHalfEven + ", scale: " + scale));
                    }
                    if (!this.compare(ceiling, jdkCeiling)) {
                        Assert.fail((String)("Incorrect ceiling: " + value + ", result: " + ceiling + ", jdkCeiling: " + jdkCeiling + ", scale: " + scale));
                    }
                    if (!this.compare(floor, jdkFloor)) {
                        Assert.fail((String)("Incorrect floor: " + value + ", result: " + floor + ", jdkFloor: " + jdkFloor + ", scale: " + scale));
                    }
                    if (!this.compare(up, jdkUp)) {
                        Assert.fail((String)("Incorrect up: " + value + ", result: " + up + ", jdkUp: " + jdkUp + ", scale: " + scale));
                    }
                    if (!this.compare(down, jdkDown)) {
                        Assert.fail((String)("Incorrect down: " + value + ", result: " + down + ", jdkDown: " + jdkDown + ", scale: " + scale));
                    }
                });
            }
        });
    }

    @Test
    public void roundScaleIntegerTest() {
        Random rnd = new Random();
        IntStream.range(-18, 0).forEach(scale -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E+" + rnd.nextInt(16)).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    double halfUp = this.roundScale((double)value, scale, RoundingMode.HALF_UP);
                    double halfDown = this.roundScale((double)value, scale, RoundingMode.HALF_DOWN);
                    double halfEven = this.roundScale((double)value, scale, RoundingMode.HALF_EVEN);
                    double ceiling = this.roundScale((double)value, scale, RoundingMode.CEILING);
                    double floor = this.roundScale((double)value, scale, RoundingMode.FLOOR);
                    double up = this.roundScale((double)value, scale, RoundingMode.UP);
                    double down = this.roundScale((double)value, scale, RoundingMode.DOWN);
                    BigDecimal decimal = BigDecimal.valueOf(value);
                    double jdkHalfUp = decimal.setScale(scale, RoundingMode.HALF_UP).doubleValue();
                    double jdkHalfDown = decimal.setScale(scale, RoundingMode.HALF_DOWN).doubleValue();
                    double jdkHalfEven = decimal.setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
                    double jdkCeiling = decimal.setScale(scale, RoundingMode.CEILING).doubleValue();
                    double jdkFloor = decimal.setScale(scale, RoundingMode.FLOOR).doubleValue();
                    double jdkUp = decimal.setScale(scale, RoundingMode.UP).doubleValue();
                    double jdkDown = decimal.setScale(scale, RoundingMode.DOWN).doubleValue();
                    if (!this.compare(halfUp, jdkHalfUp)) {
                        Assert.fail((String)("Incorrect halfUp: " + value + ", result: " + halfUp + ", jdkHalfUp: " + jdkHalfUp + ", scale: " + scale));
                    }
                    if (!this.compare(halfDown, jdkHalfDown)) {
                        Assert.fail((String)("Incorrect halfDown: " + value + ", result: " + halfDown + ", jdkHalfDown: " + jdkHalfDown + ", scale: " + scale));
                    }
                    if (!this.compare(halfEven, jdkHalfEven)) {
                        Assert.fail((String)("Incorrect halfEven: " + value + ", result: " + halfEven + ", jdkHalfEven: " + jdkHalfEven + ", scale: " + scale));
                    }
                    if (!this.compare(ceiling, jdkCeiling)) {
                        Assert.fail((String)("Incorrect ceiling: " + value + ", result: " + ceiling + ", jdkCeiling: " + jdkCeiling + ", scale: " + scale));
                    }
                    if (!this.compare(floor, jdkFloor)) {
                        Assert.fail((String)("Incorrect floor: " + value + ", result: " + floor + ", jdkFloor: " + jdkFloor + ", scale: " + scale));
                    }
                    if (!this.compare(up, jdkUp)) {
                        Assert.fail((String)("Incorrect up: " + value + ", result: " + up + ", jdkUp: " + jdkUp + ", scale: " + scale));
                    }
                    if (!this.compare(down, jdkDown)) {
                        Assert.fail((String)("Incorrect down: " + value + ", result: " + down + ", jdkDown: " + jdkDown + ", scale: " + scale));
                    }
                });
            }
        });
    }

    @Test
    public void roundPrecisionSpecificCases() {
        Assert.assertTrue((boolean)this.compare(Double.MAX_VALUE, this.roundPrecision(Double.MAX_VALUE, 0, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(Double.MAX_VALUE, this.roundPrecision(Double.MAX_VALUE, 17, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(Double.POSITIVE_INFINITY, this.roundPrecision(Double.POSITIVE_INFINITY, 5, RoundingMode.HALF_UP)));
        Assert.assertTrue((boolean)this.compare(Double.NEGATIVE_INFINITY, this.roundPrecision(Double.NEGATIVE_INFINITY, 5, RoundingMode.HALF_UP)));
        IntStream.rangeClosed(1, 17).forEach(round -> {
            Assert.assertTrue((boolean)this.compare(0.0, this.roundPrecision(0.0, round, RoundingMode.HALF_UP)));
            Assert.assertTrue((boolean)this.compare(0.0, this.roundPrecision(0.0, round, RoundingMode.HALF_DOWN)));
            Assert.assertTrue((boolean)this.compare(0.0, this.roundPrecision(0.0, round, RoundingMode.HALF_EVEN)));
            Assert.assertTrue((boolean)this.compare(0.0, this.roundPrecision(0.0, round, RoundingMode.UP)));
            Assert.assertTrue((boolean)this.compare(0.0, this.roundPrecision(0.0, round, RoundingMode.DOWN)));
            Assert.assertTrue((boolean)this.compare(0.0, this.roundPrecision(0.0, round, RoundingMode.CEILING)));
            Assert.assertTrue((boolean)this.compare(0.0, this.roundPrecision(0.0, round, RoundingMode.FLOOR)));
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> this.roundPrecision(1.0, -1, RoundingMode.HALF_UP));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.roundPrecision(1.0, -5, RoundingMode.CEILING));
    }

    @Test
    public void roundPrecisionHalfUpDownEvenStrictTest() {
        Random rnd = new Random();
        IntStream.rangeClosed(1, 15).forEach(round -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "+" : "-") + rnd.nextInt(308)).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    double halfUp = this.roundPrecision((double)value, round, RoundingMode.HALF_UP);
                    double halfDown = this.roundPrecision((double)value, round, RoundingMode.HALF_DOWN);
                    double halfEven = this.roundPrecision((double)value, round, RoundingMode.HALF_EVEN);
                    BigDecimal decimal = BigDecimal.valueOf(value);
                    double jdkUp = decimal.round(new MathContext(round, RoundingMode.HALF_UP)).doubleValue();
                    double jdkDown = decimal.round(new MathContext(round, RoundingMode.HALF_DOWN)).doubleValue();
                    double jdkEven = decimal.round(new MathContext(round, RoundingMode.HALF_EVEN)).doubleValue();
                    if (!this.compare(halfUp, jdkUp)) {
                        Assert.fail((String)("Incorrect halfUp: " + value + ", result: " + halfUp + ", jdkUp: " + jdkUp + ", round: " + round));
                    }
                    if (!this.compare(halfDown, jdkDown)) {
                        Assert.fail((String)("Incorrect halfDown: " + value + ", result: " + halfDown + ", jdkDown: " + jdkDown + ", round: " + round));
                    }
                    if (!this.compare(halfEven, jdkEven)) {
                        Assert.fail((String)("Incorrect halfEven: " + value + ", result: " + halfEven + ", jdkEven: " + jdkEven + ", round: " + round));
                    }
                });
            }
        });
    }

    @Test
    public void roundPrecisionUpDownCeilFloorStrictTest() {
        Random rnd = new Random();
        IntStream.rangeClosed(1, 16).forEach(round -> {
            for (String precision : FULL_PRECISION_FORMATS) {
                rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "+" + rnd.nextInt(17) : "-" + rnd.nextInt(308))).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                    double ceiling = this.roundPrecision((double)value, round, RoundingMode.CEILING);
                    double floor = this.roundPrecision((double)value, round, RoundingMode.FLOOR);
                    double up = this.roundPrecision((double)value, round, RoundingMode.UP);
                    double down = this.roundPrecision((double)value, round, RoundingMode.DOWN);
                    BigDecimal decimal = BigDecimal.valueOf(value);
                    double jdkCeiling = decimal.round(new MathContext(round, RoundingMode.CEILING)).doubleValue();
                    double jdkFloor = decimal.round(new MathContext(round, RoundingMode.FLOOR)).doubleValue();
                    double jdkUp = decimal.round(new MathContext(round, RoundingMode.UP)).doubleValue();
                    double jdkDown = decimal.round(new MathContext(round, RoundingMode.DOWN)).doubleValue();
                    if (!this.compare(ceiling, jdkCeiling)) {
                        Assert.fail((String)("Incorrect ceiling: " + value + ", result: " + ceiling + ", jdkCeiling: " + jdkCeiling + ", round: " + round));
                    }
                    if (!this.compare(floor, jdkFloor)) {
                        Assert.fail((String)("Incorrect floor: " + value + ", result: " + floor + ", jdkFloor: " + jdkFloor + ", round: " + round));
                    }
                    if (!this.compare(up, jdkUp)) {
                        Assert.fail((String)("Incorrect up: " + value + ", result: " + up + ", jdkUp: " + jdkUp + ", round: " + round));
                    }
                    if (!this.compare(down, jdkDown)) {
                        Assert.fail((String)("Incorrect down: " + value + ", result: " + down + ", jdkDown: " + jdkDown + ", round: " + round));
                    }
                });
            }
        });
    }

    @Test
    public void roundPrecisionHalfUpDownEvenRoughTest() {
        int round = 16;
        Random rnd = new Random();
        for (String precision : FULL_PRECISION_FORMATS) {
            rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "+" : "-") + rnd.nextInt(308)).map(Double::parseDouble).filter(value -> value != 0.0).forEach(value -> {
                double halfUp = this.roundPrecision((double)value, round, RoundingMode.HALF_UP);
                double halfDown = this.roundPrecision((double)value, round, RoundingMode.HALF_DOWN);
                double halfEven = this.roundPrecision((double)value, round, RoundingMode.HALF_EVEN);
                BigDecimal decimal = BigDecimal.valueOf(value);
                double jdkUp = decimal.round(new MathContext(round, RoundingMode.UP)).doubleValue();
                double jdkDown = decimal.round(new MathContext(round, RoundingMode.DOWN)).doubleValue();
                if (!this.compare(halfUp, jdkUp) && !this.compare(halfUp, jdkDown)) {
                    Assert.fail((String)("Incorrect round 16, halfUp: " + value + ", result: " + halfUp));
                }
                if (!this.compare(halfDown, jdkUp) && !this.compare(halfDown, jdkDown)) {
                    Assert.fail((String)("Incorrect round 16, halfDown: " + value + ", result: " + halfDown));
                }
                if (!this.compare(halfEven, jdkUp) && !this.compare(halfEven, jdkDown)) {
                    Assert.fail((String)("Incorrect round 16, halfEven: " + value + ", result: " + halfDown));
                }
            });
        }
    }

    private double roundScale(double value, int precision, RoundingMode mode) {
        return FastDoubleUtil.roundScale((double)value, (int)precision, (RoundingMode)mode);
    }

    private double roundPrecision(double value, int precision, RoundingMode mode) {
        return FastDoubleUtil.roundPrecision((double)value, (int)precision, (RoundingMode)mode);
    }

    private static String formatScale(double value, int scale) {
        return FastDoubleUtil.formatDoubleScale((double)value, (int)scale);
    }

    private static String formatPrecision(double value) {
        return FastDoubleUtil.formatDoublePrecision((double)value, (int)0);
    }

    private static String formatPrecision(double value, int precision) {
        return FastDoubleUtil.formatDoublePrecision((double)value, (int)precision);
    }

    private void parseDoubles(String str) {
        this.parseResult(str, FastDoubleUtil::parseDouble);
    }

    private void parseResult(String str, ToDoubleFunction<String> function) {
        double fast;
        double jdk = Double.parseDouble(str);
        if (!this.compare(jdk, fast = function.applyAsDouble(str))) {
            Assert.fail((String)("Not strict parsing str: " + str + ", jdk: " + jdk + ", fast: " + fast));
        }
    }

    private boolean compare(double d1, double d2) {
        return Double.doubleToLongBits(d1) == Double.doubleToLongBits(d2);
    }

    private Stream<String> generateValuesWithExponent() {
        Random rnd = new Random();
        return Arrays.stream(FULL_PRECISION_FORMATS).flatMap(precision -> rnd.doubles(1000L, -10.0, 10.0).mapToObj(value -> String.format(Locale.US, precision, value)).map(value -> value + "E" + (rnd.nextBoolean() ? "-" : "") + rnd.nextInt(309)));
    }

    private Stream<String> generateValuesWithoutExponent(double start, double end) {
        Random rnd = new Random();
        return Arrays.stream(FULL_PRECISION_FORMATS).flatMap(precision -> rnd.doubles(1000L, start, end).mapToObj(value -> (rnd.nextBoolean() ? "-" : "") + String.format(Locale.US, precision, value)));
    }
}

