/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging.test;

import com.devexperts.logging.test.StandardLogFormatterTest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultithreadingLogFormatterTest
extends StandardLogFormatterTest {
    public static final int THREADS_NUMBER = 15;
    public static final int REPEATS_NUMBER = 200;
    public static final int TIMEOUT_SECONDS = 60;
    protected CountDownLatch startSignal;
    protected CountDownLatch doneSignal;
    protected List<WorkingThread> threadList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startSignal = new CountDownLatch(1);
        this.doneSignal = new CountDownLatch(15);
        this.threadList = new ArrayList<WorkingThread>(15);
        for (int threadNumber = 0; threadNumber < 15; ++threadNumber) {
            WorkingThread thread = new WorkingThread(threadNumber);
            this.threadList.add(thread);
        }
    }

    @Test
    public void testMultithreading() throws InterruptedException {
        for (WorkingThread thread : this.threadList) {
            thread.start();
        }
        this.startSignal.countDown();
        boolean result = this.doneSignal.await(60L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Thread completion timeout expired. Probably deadlock exists.", (boolean)result);
        for (WorkingThread thread : this.threadList) {
            if (thread.error == null) continue;
            Assert.fail((String)("Exception is thrown during thread execution: " + thread.error));
        }
    }

    protected class WorkingThread
    extends Thread {
        public volatile Throwable error;

        public WorkingThread(Integer threadNumber) {
            super(Integer.toString(threadNumber));
        }

        @Override
        public void run() {
            try {
                MultithreadingLogFormatterTest.this.startSignal.await();
                try {
                    for (int iterNumber = 0; iterNumber < 200; ++iterNumber) {
                        MultithreadingLogFormatterTest.this.testFormatting();
                        MultithreadingLogFormatterTest.this.testIncorrectPattern();
                        String name = this.getName() + iterNumber * 1000;
                        MultithreadingLogFormatterTest.this.checkResultMatches(name, "_" + name);
                    }
                }
                catch (Throwable e) {
                    this.error = e;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MultithreadingLogFormatterTest.this.doneSignal.countDown();
        }
    }
}

