/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.test.isolated.Isolated;
import com.devexperts.test.isolated.IsolatedRunner;
import com.devexperts.util.Indexer;
import com.devexperts.util.IndexerFunction;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=IsolatedRunner.class)
@Isolated(value={"com.devexperts.util"})
public class IndexerInitTest {
    @Test
    public void testIndexerInitialization() throws InterruptedException {
        CountDownLatch startFlag = new CountDownLatch(2);
        CountDownLatch finishFlag = new CountDownLatch(2);
        Thread t1 = new Thread(() -> {
            IndexerInitTest.waitStart(startFlag);
            IndexerFunction indexerFunction = IndexerFunction.DEFAULT;
            finishFlag.countDown();
        });
        Thread t2 = new Thread(() -> {
            IndexerInitTest.waitStart(startFlag);
            Indexer indexer = Indexer.DEFAULT;
            finishFlag.countDown();
        });
        t1.start();
        t2.start();
        Assert.assertTrue((String)"Initialization threads timed out", (boolean)finishFlag.await(1L, TimeUnit.MINUTES));
    }

    static void waitStart(CountDownLatch startFlag) {
        startFlag.countDown();
        try {
            if (!startFlag.await(1L, TimeUnit.MINUTES)) {
                throw new RuntimeException("Waiting for a start flag timed out");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

