/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import com.devexperts.io.test.ObjectUtilTest;
import java.io.IOException;
import org.junit.Test;

public class CompactPrimitiveTest {
    @Test
    public void testCompactPrimitive() throws IOException {
        CompactPrimitiveTest.checkReadWrite(null, Void.TYPE);
        CompactPrimitiveTest.checkReadWrite(true, Boolean.TYPE);
        CompactPrimitiveTest.checkReadWrite((byte)123, Byte.TYPE);
        CompactPrimitiveTest.checkReadWrite(Character.valueOf('%'), Character.TYPE);
        CompactPrimitiveTest.checkReadWrite((short)12345, Short.TYPE);
        CompactPrimitiveTest.checkReadWrite(1234567890, Integer.TYPE);
        CompactPrimitiveTest.checkReadWrite(1234567890123456789L, Long.TYPE);
        CompactPrimitiveTest.checkReadWrite(Float.valueOf(1.2345f), Float.TYPE);
        CompactPrimitiveTest.checkReadWrite(1.2345, Double.TYPE);
        CompactPrimitiveTest.checkReadWrite("Abc!", String.class);
        CompactPrimitiveTest.checkReadWrite("", String.class);
        CompactPrimitiveTest.checkReadWrite(null, String.class);
        CompactPrimitiveTest.checkReadWrite(null, byte[].class);
        String[][][][][] sss = new String[1][2][3][4][5];
        sss[0][1][2][3][4] = "hi!";
        sss[0][0][1][2][3] = "=)";
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                sss[0][1][0][i][j] = i + "" + j;
            }
        }
        CompactPrimitiveTest.checkReadWrite(sss, String[][][][][].class);
    }

    private static void checkReadWrite(Object value, Class<?> clazz) throws IOException {
        byte[] bytes = Marshalled.forObject((Object)new Object[]{value}, (Marshaller)Marshaller.forClasses((Class[])new Class[]{clazz})).getBytes();
        Object result = ((Object[])Marshalled.forBytes((byte[])bytes, (Marshaller)Marshaller.forClasses((Class[])new Class[]{clazz})).getObject())[0];
        ObjectUtilTest.assertDeepEquals(value, result);
    }
}

