/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging.test;

import com.devexperts.logging.Logging;
import com.devexperts.logging.test.LogFormatterTestBase;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class Log4jCompatibilityTest
extends LogFormatterTestBase {
    private static final Category log = Category.getInstance(Log4jCompatibilityTest.class);
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File logFile;

    @Before
    public void setUp() throws Exception {
        System.setProperty("log.className", "com.devexperts.logging.Log4jLogging");
        this.initLogFormatter();
        Properties props = new Properties();
        props.load(Log4jCompatibilityTest.class.getResourceAsStream("/test.log4j.properties"));
        this.logFile = new File(this.tempFolder.getRoot(), "test.log");
        props.setProperty("log4j.appender.commonFileAppender.file", this.logFile.getPath());
        PropertyConfigurator.configure((Properties)props);
    }

    @After
    public void tearDown() throws Exception {
        Category.shutdown();
        Category.getDefaultHierarchy().resetConfiguration();
    }

    protected void initLogFormatter() {
        System.setProperty("logformatter.properties", Log4jCompatibilityTest.class.getResource("/test.logformatter.properties").toExternalForm());
    }

    @Test
    public void testLog4JLogging() throws IOException {
        String log4jVersion = Package.getPackage("org.apache.log4j").getImplementationVersion();
        String log4jMessage = "Log4j version: ";
        String testMessage = "Test log4j message";
        log.debug((Object)("Log4j version: " + log4jVersion));
        log.debug((Object)"Test log4j message");
        log.debug((Object)"error", (Throwable)new IllegalArgumentException());
        String content = Log4jCompatibilityTest.loadFile(this.logFile);
        Assert.assertTrue((String)"'Log4j version: ' not found in the log", (boolean)content.contains("Log4j version: "));
        Assert.assertTrue((String)"'Test log4j message' not found in log file", (boolean)content.contains("Test log4j message"));
        Assert.assertTrue((String)"Exception not found in log file", (boolean)content.contains(IllegalArgumentException.class.getName()));
        Assert.assertTrue((String)"Exception stack trace not found in log file", (boolean)content.contains("\tat " + this.getClass().getName()));
    }

    @Test
    public void testDevexpertsLogging() throws IOException {
        Logging log = Logging.getLogging(Log4jCompatibilityTest.class);
        log.configureDebugEnabled(true);
        String testMessage = "Test com.devexperts.logging message";
        log.debug("Test com.devexperts.logging message");
        log.debug("error", (Throwable)new IllegalArgumentException());
        String content = Log4jCompatibilityTest.loadFile(this.logFile);
        Assert.assertTrue((String)"'Test com.devexperts.logging message' not found in log file", (boolean)content.contains("Test com.devexperts.logging message"));
        Assert.assertTrue((String)"Exception not found in log file", (boolean)content.contains(IllegalArgumentException.class.getName()));
        Assert.assertTrue((String)"Exception stack trace not found in log file", (boolean)content.contains("\tat " + this.getClass().getName()));
    }

    @Test
    public void testConfigureDebugEnabled() throws IOException {
        this.goTestConfigureDebugEnbled(true);
    }

    @Test
    public void testConfigureDebugDisabled() throws IOException {
        this.goTestConfigureDebugEnbled(false);
    }

    private void goTestConfigureDebugEnbled(boolean defaultDebugEnabled) throws IOException {
        Logging log = Logging.getLogging(Log4jCompatibilityTest.class);
        Category defaultLog = Category.getInstance((String)"default.test");
        Category errorLog = Category.getInstance((String)"default.error");
        Assert.assertEquals((Object)Priority.DEBUG, (Object)defaultLog.getChainedPriority());
        Assert.assertEquals((Object)Priority.ERROR, (Object)errorLog.getPriority());
        List<Category> loggers = Arrays.asList(defaultLog, errorLog);
        List<Priority> levels = Arrays.asList(Priority.ERROR, Priority.WARN, Priority.INFO, Priority.DEBUG);
        for (Category logger : loggers) {
            Logging.getLogging((String)logger.getName()).configureDebugEnabled(defaultDebugEnabled);
            for (Priority level : levels) {
                logger.log(level, (Object)(logger.getName() + "-" + level.toString()));
            }
        }
        String content = Log4jCompatibilityTest.loadFile(this.logFile);
        if (defaultDebugEnabled) {
            loggers.forEach(l -> Assert.assertTrue((String)("Debug disabled for " + l.getName()), (boolean)Logging.getLogging((String)l.getName()).debugEnabled()));
            this.checkLevelRange(defaultLog, levels, content, Priority.ERROR, Priority.DEBUG);
            this.checkLevelRange(errorLog, levels, content, Priority.ERROR, Priority.DEBUG);
        } else {
            loggers.forEach(l -> Assert.assertFalse((String)("Debug enabled for " + l.getName()), (boolean)Logging.getLogging((String)l.getName()).debugEnabled()));
            this.checkLevelRange(defaultLog, levels, content, Priority.ERROR, Priority.INFO);
            this.checkLevelRange(errorLog, levels, content, Priority.ERROR, Priority.ERROR);
        }
    }

    private void checkLevelRange(Category logger, List<Priority> levels, String content, Priority top, Priority low) {
        assert (top.isGreaterOrEqual(low)) : "more specific log4j priorities has higher int-values";
        String name = logger.getName();
        for (Priority level : levels) {
            boolean expected = level.isGreaterOrEqual(low) && top.isGreaterOrEqual(level);
            Assert.assertEquals((String)((expected ? "Expected" : "Unexpected") + " message of level " + level + " for logger " + name), (Object)expected, (Object)content.contains(logger.getName() + "-" + level.toString()));
        }
    }
}

