/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import org.junit.Assert;

class TrackingChunkPool
extends ChunkPool {
    int gc;
    int rc;
    int gl;
    int rl;

    TrackingChunkPool() {
        super("<test>", 3, 1, 1, 100, 1);
    }

    public Chunk getChunk(Object owner) {
        ++this.gc;
        return super.getChunk(owner);
    }

    public ChunkList getChunkList(Object owner) {
        ++this.gl;
        return super.getChunkList(owner);
    }

    protected void recycleChunk(Chunk chunk, Object owner) {
        ++this.rc;
        super.recycleChunk(chunk, owner);
    }

    protected void recycleChunkList(ChunkList chunkList, Object owner) {
        ++this.rl;
        super.recycleChunkList(chunkList, owner);
    }

    void checkCounters(int gc, int rc, int gl, int rl) {
        if (gc >= 0) {
            Assert.assertEquals((String)"acquired chunks", (long)gc, (long)this.gc);
        }
        if (rc >= 0) {
            Assert.assertEquals((String)"recycled chunks", (long)rc, (long)this.rc);
        }
        if (gl >= 0) {
            Assert.assertEquals((String)"acquired chunk lists", (long)gl, (long)this.gl);
        }
        if (rl >= 0) {
            Assert.assertEquals((String)"recycled chunk lists", (long)rl, (long)this.rl);
        }
    }

    void clearCounters() {
        this.rl = 0;
        this.gl = 0;
        this.rc = 0;
        this.gc = 0;
    }

    void checkAndClearCounters(int gc, int rc, int gl, int rl) {
        this.checkCounters(gc, rc, gl, rl);
        this.clearCounters();
    }
}

