/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.LogUtil;
import org.junit.Assert;
import org.junit.Test;

public class LogUtilTest {
    @Test
    public void testHideCredentials() {
        LogUtilTest.doHide("host:7000");
        LogUtilTest.doHide("host:7000[user=]");
        LogUtilTest.doHide("host:7000[user=,password=]");
        LogUtilTest.doHide("host:7000[user=ABC]");
        LogUtilTest.doHide("host:7000[user=ABC,user=ABC][user=ABC](user=ABC,user=ABC)(user=ABC)");
        LogUtilTest.doHide("host:7000(user=ABC,password=ABC)[password=ABC](password=ABC,password=ABC)");
        LogUtilTest.doHide("http://host");
        LogUtilTest.doHide("hTTp://@host");
        LogUtilTest.doHide("TttP://ABC@");
        LogUtilTest.doHide("http://ABC@host");
        LogUtilTest.doHide("hTTp://ABC:ABC@host");
        LogUtilTest.doHide("https://ABC:ABC@host");
        LogUtilTest.doHide("httpS://ABC@ABC@host");
        LogUtilTest.doHide("HttpS://ABC@ABC:ABC@host");
        LogUtilTest.doHide("ftp://ABC:ABC@host");
        LogUtilTest.doHide("FTP://ABC:ABC@host");
        LogUtilTest.doHide("http://host?password=ABC");
        LogUtilTest.doHide("http://host?password=ABC&help&user=ABC");
        LogUtilTest.doHide("http://host?help&password=ABC");
        LogUtilTest.doHide("http://host?help,password=ABC;hello");
        LogUtilTest.doHide("address=((feed,chartdata)&ipf[https://tools.dxfeed.com/ipf?user=ABC,user=ABC,password=ABC,update=1h]@mux-retail:7800)");
        LogUtilTest.doHide("address=((feed,chartdata)&ipf[https://ABC:ABC@tools.dxfeed.com/ipf?user=ABC&user=ABC&password=ABC,update=1h]@mux-retail:7800)");
        LogUtilTest.doHide("address=((feed,chartdata)&ipf[https://ABC@ABC@tools.dxfeed.com/ipf?user=ABC&user=ABC&password=ABC,update=1h]@mux-retail:7800)");
        LogUtilTest.doHide("address=((feed,chartdata)&ipf[https://ABC@ABC:ABC@tools.dxfeed.com/ipf?user=ABC&user=ABC&password=ABC,update=1h]@mux-retail:7800)");
    }

    private static void doHide(String s) {
        String expect = s.replaceAll("ABC@ABC", "ABC").replaceAll("ABC:ABC", "ABC").replaceAll("ABC", "****");
        String actual = LogUtil.hideCredentials((Object)s);
        Assert.assertEquals((Object)expect, (Object)actual);
    }
}

