/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging.test;

import com.devexperts.logging.Logging;
import com.devexperts.logging.test.LogFormatterTestBase;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class Log4j2CompatibilityTest
extends LogFormatterTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File logFile;

    @Before
    public void setUp() throws Exception {
        System.setProperty("log.className", "com.devexperts.logging.Log4j2Logging");
        this.initLogFormatter();
        this.logFile = new File(this.tempFolder.getRoot(), "test.log");
        final Properties props = new Properties();
        props.load(Log4j2CompatibilityTest.class.getResourceAsStream("/test.log4j2.properties"));
        props.setProperty("appender.file.fileName", this.logFile.getPath());
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new PropertiesConfigurationFactory(){

            public PropertiesConfiguration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
                return new PropertiesConfigurationBuilder().setConfigurationSource(source).setRootProperties(props).setLoggerContext(loggerContext).build();
            }
        });
        context.setConfigLocation(Log4j2CompatibilityTest.class.getResource("/test.log4j2.properties").toURI());
    }

    protected void initLogFormatter() {
        System.setProperty("logformatter.properties", Log4j2CompatibilityTest.class.getResource("/test.logformatter.properties").toExternalForm());
    }

    @Test
    public void testLog4JLogging() throws IOException {
        ExtendedLogger logger = LogManager.getContext((boolean)false).getLogger("file");
        String log4jVersion = Package.getPackage("org.apache.logging.log4j.core").getImplementationVersion();
        String log4jMessage = "Log4j version: ";
        String testMessage = "Test log4j message";
        logger.debug("Log4j version: " + log4jVersion);
        logger.debug("Test log4j message");
        logger.debug("error", (Throwable)new IllegalArgumentException());
        logger.debug("Test log4j message");
        String content = Log4j2CompatibilityTest.loadFile(this.logFile);
        Assert.assertTrue((String)"'Log4j version: ' not found in the log", (boolean)content.contains("Log4j version: "));
        Assert.assertTrue((String)"'Test log4j message' not found in log file", (boolean)content.contains("Test log4j message"));
        Assert.assertTrue((String)"Exception not found in log file", (boolean)content.contains(IllegalArgumentException.class.getName()));
        Assert.assertTrue((String)"Exception stack trace not found in log file", (boolean)content.contains("\tat " + this.getClass().getName()));
    }

    @Test
    public void testDevexpertsLogging() throws IOException {
        Logging log = Logging.getLogging(Log4j2CompatibilityTest.class);
        log.configureDebugEnabled(true);
        String testMessage = "Test com.devexperts.logging message";
        log.debug("Test com.devexperts.logging message");
        log.debug("error", (Throwable)new IllegalArgumentException());
        log.debug("Test com.devexperts.logging message");
        String content = Log4j2CompatibilityTest.loadFile(this.logFile);
        Assert.assertTrue((String)"'Test com.devexperts.logging message' not found in log file", (boolean)content.contains("Test com.devexperts.logging message"));
        Assert.assertTrue((String)"Exception not found in log file", (boolean)content.contains(IllegalArgumentException.class.getName()));
        Assert.assertTrue((String)"Exception stack trace not found in log file", (boolean)content.contains("\tat " + this.getClass().getName()));
    }

    @Test
    public void testConfigureDebugEnabled() throws IOException {
        this.goTestConfigureDebugEnbled(true);
    }

    @Test
    public void testConfigureDebugDisabled() throws IOException {
        this.goTestConfigureDebugEnbled(false);
    }

    private void goTestConfigureDebugEnbled(boolean defaultDebugEnabled) throws IOException {
        Logger defaultLog = LogManager.getLogger((String)"default.test");
        Logger errorLog = LogManager.getLogger((String)"default.error");
        Logger traceLog = LogManager.getLogger((String)"default.trace");
        Assert.assertEquals((Object)Level.DEBUG, (Object)defaultLog.getLevel());
        Assert.assertEquals((Object)Level.ERROR, (Object)errorLog.getLevel());
        Assert.assertEquals((Object)Level.TRACE, (Object)traceLog.getLevel());
        List<Logger> loggers = Arrays.asList(defaultLog, errorLog, traceLog);
        List<Level> levels = Arrays.asList(Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE);
        for (Logger logger : loggers) {
            Logging.getLogging((String)logger.getName()).configureDebugEnabled(defaultDebugEnabled);
            for (Level level : levels) {
                logger.log(level, logger.getName() + "-" + level.name());
            }
        }
        String content = Log4j2CompatibilityTest.loadFile(this.logFile);
        if (defaultDebugEnabled) {
            loggers.forEach(l -> Assert.assertTrue((String)("Debug disabled for " + l.getName()), (boolean)Logging.getLogging((String)l.getName()).debugEnabled()));
            this.checkLevelRange(defaultLog, levels, content, Level.ERROR, Level.DEBUG);
            this.checkLevelRange(errorLog, levels, content, Level.ERROR, Level.DEBUG);
            this.checkLevelRange(traceLog, levels, content, Level.ERROR, Level.TRACE);
        } else {
            loggers.forEach(l -> Assert.assertFalse((String)("Debug enabled for " + l.getName()), (boolean)Logging.getLogging((String)l.getName()).debugEnabled()));
            this.checkLevelRange(defaultLog, levels, content, Level.ERROR, Level.INFO);
            this.checkLevelRange(errorLog, levels, content, Level.ERROR, Level.ERROR);
            this.checkLevelRange(traceLog, levels, content, Level.ERROR, Level.INFO);
        }
    }

    private void checkLevelRange(Logger logger, List<Level> levels, String content, Level min, Level max) {
        String name = logger.getName();
        for (Level level : levels) {
            boolean expected = level.isInRange(min, max);
            Assert.assertEquals((String)((expected ? "Expected" : "Unexpected") + " message of level " + level + " for logger " + name), (Object)expected, (Object)content.contains(logger.getName() + "-" + level.name()));
        }
    }
}

