/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging.test;

import com.devexperts.logging.LogFormatter;
import com.devexperts.logging.test.LogFormatterTestBase;
import com.devexperts.util.TimeUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StandardLogFormatterTest
extends LogFormatterTestBase {
    @Before
    public void setUp() throws Exception {
        this.initLogFormatter();
        this.formatter = new LogFormatter();
    }

    protected void initLogFormatter() throws Exception {
        System.setProperty("logformatter.properties", StandardLogFormatterTest.class.getResource("/test.logformatter.properties").toExternalForm());
    }

    @Test
    public void testFormatting() {
        this.checkResultMatches("NotMatchingThread", "NotMatchingThread");
        this.checkResultDoesNotMatch("#a", "ABC");
        this.checkResultMatches("=Thread1", "Thread2");
        this.checkResultMatches("A=B=C=Thread1", "Thread3");
        this.checkResultMatches("Thread123Number", "T123N");
        this.checkResultMatches("Butrqwerty123", "Butrqwerty123But");
    }

    @Test
    public void testIncorrectPattern() {
        this.checkResultMatches("_Thread", "_Thread");
    }

    @Test
    public void testDaylightSwitchFormatting() {
        LogFormatter log = new LogFormatter(TimeUtil.getTimeZone((String)"Europe/Moscow"));
        long time = 1269725412345L;
        this.check(log, time, 0, "D 100328 003012.345 [qwe] asd - zxc");
        this.check(log, time, 1, "D 100328 013012.345 [qwe] asd - zxc");
        this.check(log, time, 2, "D 100328 033012.345 [qwe] asd - zxc");
        this.check(log, time, 3, "D 100328 043012.345 [qwe] asd - zxc");
        time = 1288470612345L;
        this.check(log, time, 0, "D 101031 003012.345 [qwe] asd - zxc");
        this.check(log, time, 1, "D 101031 013012.345 [qwe] asd - zxc");
        this.check(log, time, 2, "D 101031 023012.345 [qwe] asd - zxc");
        this.check(log, time, 3, "D 101031 023012.345 [qwe] asd - zxc");
        this.check(log, time, 4, "D 101031 033012.345 [qwe] asd - zxc");
        this.check(log, time, 5, "D 101031 043012.345 [qwe] asd - zxc");
    }

    private void check(LogFormatter log, long time, int hour, String expected) {
        String s = log.format('D', time + (long)hour * 3600000L, "qwe", "asd", "zxc");
        while (s.charAt(s.length() - 1) < ' ') {
            s = s.substring(0, s.length() - 1);
        }
        Assert.assertEquals((Object)s, (Object)expected);
    }
}

