/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.test.isolated;

import com.devexperts.test.isolated.Isolated;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.junit.runners.model.InitializationError;

class IsolatedClassLoader
extends URLClassLoader {
    private final String[] patternsToIsolate;

    private IsolatedClassLoader(String[] patternsToIsolate) {
        super(((URLClassLoader)IsolatedClassLoader.getSystemClassLoader()).getURLs());
        this.patternsToIsolate = (String[])patternsToIsolate.clone();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (String pattern : this.patternsToIsolate) {
            if (!name.startsWith(pattern)) continue;
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            return this.findClass(name);
        }
        return super.loadClass(name);
    }

    public static Class<?> isolatedTestClass(Class<?> testClass) throws InitializationError {
        String testClassName = testClass.getName();
        Isolated annotation = testClass.getAnnotation(Isolated.class);
        String[] isolatedPatterns = annotation != null ? annotation.value() : new String[]{};
        String[] allPatterns = Arrays.copyOf(isolatedPatterns, isolatedPatterns.length + 1);
        allPatterns[isolatedPatterns.length] = testClassName;
        IsolatedClassLoader classLoader = new IsolatedClassLoader(allPatterns);
        try {
            return classLoader.loadClass(testClassName);
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            throw new InitializationError((Throwable)e);
        }
    }
}

