/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.ConfigUtil;
import com.devexperts.util.InvalidFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.junit.Assert;
import org.junit.Test;

public class ConfigUtilTest {
    @Test
    public void testBooleanValidValues() {
        Assert.assertTrue((String)"'true' should be true", (boolean)((Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"true")));
        Assert.assertFalse((String)"'false' should be false", (boolean)((Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"false")));
        Assert.assertTrue((String)"Empty string should be true", (boolean)((Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"")));
        Assert.assertTrue((boolean)((Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"TRUE")));
        Assert.assertTrue((boolean)((Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"TrUe")));
        Assert.assertFalse((boolean)((Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"FALSE")));
        Assert.assertFalse((boolean)((Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"FalSe")));
    }

    @Test
    public void testBooleanInvalidValues() {
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"1");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"0");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"yes");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"no");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"t");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"f");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"random");
        });
    }

    @Test
    public void testByteValidValues() {
        Assert.assertEquals((String)"'max' should return Byte.MAX_VALUE", (long)127L, (long)((Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"max")).byteValue());
        Assert.assertEquals((String)"Byte.MAX_VALUE should be 127", (long)127L, (long)((Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"127")).byteValue());
        Assert.assertEquals((String)"Byte.MIN_VALUE should be -128", (long)-128L, (long)((Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"-128")).byteValue());
        Assert.assertEquals((String)"0 should be 0", (long)0L, (long)((Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"0")).byteValue());
        Assert.assertEquals((String)"123 should be 123", (long)123L, (long)((Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"123")).byteValue());
    }

    @Test
    public void testShortValidValues() {
        Assert.assertEquals((String)"'max' should return Short.MAX_VALUE", (long)32767L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"max")).shortValue());
        Assert.assertEquals((String)"Short.MAX_VALUE should parse correctly", (long)32767L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)Short.toString((short)Short.MAX_VALUE))).intValue());
        Assert.assertEquals((String)"Short.MIN_VALUE should parse correctly", (long)-32768L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)Short.toString((short)Short.MIN_VALUE))).intValue());
        Assert.assertEquals((String)"1k should be 1000", (long)1000L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"1k")).shortValue());
        Assert.assertEquals((String)"10k should be 10000", (long)10000L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"10k")).shortValue());
        Assert.assertEquals((String)"1Ki should be 1024", (long)1024L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"1Ki")).shortValue());
        Assert.assertEquals((String)"-1k should be -1000", (long)-1000L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"-1k")).shortValue());
        Assert.assertEquals((String)"1.5k should be 1500", (long)1500L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"1.5k")).shortValue());
        Assert.assertEquals((String)"0 should be 0", (long)0L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"0")).shortValue());
        Assert.assertEquals((String)"12345 should be 12345", (long)12345L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"12345")).shortValue());
    }

    @Test
    public void testIntValidValues() {
        Assert.assertEquals((String)"'max' should return Integer.MAX_VALUE", (long)Integer.MAX_VALUE, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"max")).intValue());
        Assert.assertEquals((String)"Integer.MAX_VALUE should parse correctly", (long)Integer.MAX_VALUE, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)Integer.toString(Integer.MAX_VALUE))).intValue());
        Assert.assertEquals((String)"Integer.MIN_VALUE should parse correctly", (long)Integer.MIN_VALUE, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)Integer.toString(Integer.MIN_VALUE))).intValue());
        Assert.assertEquals((String)"1k should be 1000", (long)1000L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1k")).intValue());
        Assert.assertEquals((String)"1.5k should be 1500", (long)1500L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1.5k")).intValue());
        Assert.assertEquals((String)"2M should be 2000000", (long)2000000L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"2M")).intValue());
        Assert.assertEquals((String)"1Ki should be 1024", (long)1024L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1Ki")).intValue());
        Assert.assertEquals((String)"2Mi should be 2097152", (long)0x200000L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"2Mi")).intValue());
        Assert.assertEquals((String)"-100 should be -100", (long)-100L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"-100")).intValue());
        Assert.assertEquals((String)"1.5k should be 1500", (long)1500L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1.5k")).intValue());
    }

    @Test
    public void testLongValidValues() {
        Assert.assertEquals((String)"'max' should return Long.MAX_VALUE", (long)Long.MAX_VALUE, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"max")));
        Assert.assertEquals((String)"Long.MAX_VALUE should parse correctly", (long)Long.MAX_VALUE, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)Long.toString(Long.MAX_VALUE))));
        Assert.assertEquals((String)"Long.MIN_VALUE should parse correctly", (long)Long.MIN_VALUE, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)Long.toString(Long.MIN_VALUE))));
        Assert.assertEquals((String)"1G should be 1000000000", (long)1000000000L, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"1G")));
        Assert.assertEquals((String)"1.5G should be 1500000000", (long)1500000000L, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"1.5G")));
        Assert.assertEquals((String)"1T should be 1000000000000", (long)1000000000000L, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"1T")));
        Assert.assertEquals((String)"1Gi should be 1073741824", (long)0x40000000L, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"1Gi")));
        Assert.assertEquals((String)"1Ti should be 1099511627776", (long)0x10000000000L, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"1Ti")));
        Assert.assertEquals((String)"2.5G should be 2500000000", (long)2500000000L, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"2.5G")));
    }

    @Test
    public void testFloatValidValues() {
        Assert.assertEquals((String)"Valid float value", (float)123.456f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"123.456")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1.23456789 should be 1.23456789", (float)1.2345679f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1.23456789")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1.23456789k should be 1234.56789", (float)1234.5679f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1.23456789k")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1M should be 1000000.0", (float)1000000.0f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1M")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1G should be 1000000000.0", (float)1.0E9f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1G")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1T should be 1000000000000.0", (float)1.0E12f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1T")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1ki should be 1024.0", (float)1024.0f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1ki")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1Mi should be 1048576.0", (float)1048576.0f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1Mi")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1Gi should be 1073741824.0", (float)1.0737418E9f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1Gi")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"1Ti should be 1099511627776.0", (float)1.0995116E12f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1Ti")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"'max' should return Float.MAX_VALUE", (float)Float.MAX_VALUE, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"max")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"Float.MAX_VALUE should parse correctly", (float)Float.MAX_VALUE, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)BigDecimal.valueOf(3.4028234663852886E38).toPlainString())).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"-Float.MAX_VALUE should parse correctly", (float)-3.4028235E38f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)BigDecimal.valueOf(-3.4028234663852886E38).toPlainString())).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"Float.MIN_VALUE should parse correctly", (float)Float.MIN_VALUE, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)BigDecimal.valueOf(1.4E-45f).toPlainString())).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"-Float.MIN_VALUE should parse correctly", (float)-1.4E-45f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)BigDecimal.valueOf(-1.4E-45f).toPlainString())).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"Infinity should parse to POSITIVE_INFINITY", (float)Float.POSITIVE_INFINITY, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"Infinity")).floatValue(), (float)0.0f);
        Assert.assertEquals((String)"-Infinity should parse to NEGATIVE_INFINITY", (float)Float.NEGATIVE_INFINITY, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"-Infinity")).floatValue(), (float)0.0f);
        Assert.assertTrue((String)"NaN should parse to Float.NaN", (boolean)Float.isNaN(((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"NaN")).floatValue()));
        Assert.assertEquals((String)"Zero float", (float)0.0f, (float)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"0")).floatValue(), (float)0.0f);
    }

    @Test
    public void testDoubleValidValues() {
        Assert.assertEquals((String)"Valid double value", (double)123.456, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"123.456")), (double)0.0);
        Assert.assertEquals((String)"1.23456789 should be 1.23456789", (double)1.23456789, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1.23456789")), (double)0.0);
        Assert.assertEquals((String)"1.23456789k should be 1234.56789", (double)1234.56789, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1.23456789k")), (double)0.0);
        Assert.assertEquals((String)"1M should be 1000000.0", (double)1000000.0, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1M")), (double)0.0);
        Assert.assertEquals((String)"1G should be 1000000000.0", (double)1.0E9, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1G")), (double)0.0);
        Assert.assertEquals((String)"1T should be 1000000000000.0", (double)1.0E12, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1T")), (double)0.0);
        Assert.assertEquals((String)"1ki should be 1024.0", (double)1024.0, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1ki")), (double)0.0);
        Assert.assertEquals((String)"1Mi should be 1048576.0", (double)1048576.0, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1Mi")), (double)0.0);
        Assert.assertEquals((String)"1Gi should be 1073741824.0", (double)1.073741824E9, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1Gi")), (double)0.0);
        Assert.assertEquals((String)"1Ti should be 1099511627776.0", (double)1.099511627776E12, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1Ti")), (double)0.0);
        Assert.assertEquals((String)"'max' should return Double.MAX_VALUE", (double)Double.MAX_VALUE, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"max")), (double)0.0);
        Assert.assertEquals((String)"Double.MAX_VALUE should parse correctly", (double)Double.MAX_VALUE, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)BigDecimal.valueOf(Double.MAX_VALUE).setScale(325, RoundingMode.HALF_UP).toPlainString())), (double)0.0);
        Assert.assertEquals((String)"-Double.MAX_VALUE should parse correctly", (double)-1.7976931348623157E308, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)BigDecimal.valueOf(-1.7976931348623157E308).setScale(325, RoundingMode.HALF_UP).toPlainString())), (double)0.0);
        Assert.assertEquals((String)"Double.MIN_VALUE should parse correctly", (double)Double.MIN_VALUE, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)BigDecimal.valueOf(Double.MIN_VALUE).setScale(325, RoundingMode.HALF_UP).toPlainString())), (double)0.0);
        Assert.assertEquals((String)"-Double.MIN_VALUE should parse correctly", (double)-4.9E-324, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)BigDecimal.valueOf(-4.9E-324).setScale(325, RoundingMode.HALF_UP).toPlainString())), (double)0.0);
        Assert.assertEquals((String)"Infinity should parse to POSITIVE_INFINITY", (double)Double.POSITIVE_INFINITY, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"Infinity")), (double)0.0);
        Assert.assertEquals((String)"-Infinity should parse to NEGATIVE_INFINITY", (double)Double.NEGATIVE_INFINITY, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"-Infinity")), (double)0.0);
        Assert.assertTrue((String)"NaN should parse to Double.NaN", (boolean)Double.isNaN((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"NaN")));
        Assert.assertEquals((String)"Zero double", (double)0.0, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"0")), (double)0.0);
    }

    @Test
    public void testValidNumberFormat() {
        Assert.assertNull((String)"Null value should return null for Boolean wrapper", (Object)ConfigUtil.convertStringToObject(Boolean.class, null));
        Assert.assertNull((String)"Null value should return null for Byte wrapper", (Object)ConfigUtil.convertStringToObject(Byte.class, null));
        Assert.assertNull((String)"Null value should return null for Short wrapper", (Object)ConfigUtil.convertStringToObject(Short.class, null));
        Assert.assertNull((String)"Null value should return null for Integer wrapper", (Object)ConfigUtil.convertStringToObject(Integer.class, null));
        Assert.assertNull((String)"Null value should return null for Long wrapper", (Object)ConfigUtil.convertStringToObject(Long.class, null));
        Assert.assertNull((String)"Null value should return null for Float wrapper", (Object)ConfigUtil.convertStringToObject(Float.class, null));
        Assert.assertNull((String)"Null value should return null for Double wrapper", (Object)ConfigUtil.convertStringToObject(Double.class, null));
        Assert.assertEquals((String)"Lowercase 'k' should work", (long)1000L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1k")).intValue());
        Assert.assertEquals((String)"Uppercase 'K' should work", (long)1000L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1K")).intValue());
        Assert.assertEquals((String)"Lowercase 'ki' should work", (long)1024L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1ki")).intValue());
        Assert.assertEquals((String)"Mixed case 'Ki' should work", (long)1024L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1Ki")).intValue());
        Assert.assertEquals((String)"Uppercase 'KI' should work", (long)1024L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1KI")).intValue());
        Assert.assertEquals((String)"'max' should return Integer.MAX_VALUE", (long)Integer.MAX_VALUE, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"max")).intValue());
        Assert.assertEquals((String)"'MAX' should return Integer.MAX_VALUE", (long)Integer.MAX_VALUE, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"MAX")).intValue());
        Assert.assertEquals((String)"'Max' should return Integer.MAX_VALUE", (long)Integer.MAX_VALUE, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"Max")).intValue());
        Assert.assertEquals((String)"1e2 should parse as 100", (long)100L, (long)((Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"1e2")).byteValue());
        Assert.assertEquals((String)"1e3 should parse as 1000", (long)1000L, (long)((Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"1e3")).shortValue());
        Assert.assertEquals((String)"1e3 should parse as 1000", (long)1000L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1e3")).intValue());
        Assert.assertEquals((String)"1e9 should parse as 1000000000", (long)1000000000L, (long)((Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"1e9")));
        Assert.assertEquals((String)"1e5 should parse as 100000", (double)100000.0, (double)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1e5")).floatValue(), (double)0.0);
        Assert.assertEquals((String)"1.23E5 should parse as 123000", (double)123000.0, (double)((Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"1.23E5")).floatValue(), (double)0.0);
        Assert.assertEquals((String)"1e5 should parse as 100000", (double)100000.0, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1e5")), (double)0.0);
        Assert.assertEquals((String)"1.23E5 should parse as 123000", (double)123000.0, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"1.23E5")), (double)0.0);
        Assert.assertEquals((String)"Leading zeros should be ignored", (long)123L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"00123")).intValue());
        Assert.assertEquals((String)"Multiple zeros should be parsed as zero", (long)0L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"0000")).intValue());
        Assert.assertEquals((String)"010 should be parsed as decimal 10, not octal", (long)10L, (long)((Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"010")).intValue());
        Assert.assertEquals((String)"123. should parse as 123.0", (double)123.0, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"123.")), (double)0.0);
        Assert.assertEquals((String)".456 should parse as 0.456", (double)0.456, (double)((Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)".456")), (double)0.0);
    }

    @Test
    public void testInvalidNumberFormat() {
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, null);
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, null);
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, null);
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, null);
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, null);
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Float cfr_ignored_0 = (Float)ConfigUtil.convertStringToObject(Float.TYPE, null);
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, null);
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)"not-a-number");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"not-a-number");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"not-a-number");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"not-a-number");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"not-a-number");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Float cfr_ignored_0 = (Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"not-a-number");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"not-a-number");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Float cfr_ignored_0 = (Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)"");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"12.3");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"12.3456");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"12.3456k");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"123.456");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"123.4567k");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"123.456");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"123.4567k");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)ConfigUtil.convertStringToObject(Boolean.TYPE, (String)" true");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)" 123");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"123 ");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1 k");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)" 123 ");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Float cfr_ignored_0 = (Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)" 12 .3");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"123. 0");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)"1k");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)Short.toString((short)128));
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Byte cfr_ignored_0 = (Byte)ConfigUtil.convertStringToObject(Byte.TYPE, (String)Short.toString((short)-129));
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)"327k");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)Integer.toString(32768));
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Short cfr_ignored_0 = (Short)ConfigUtil.convertStringToObject(Short.TYPE, (String)Integer.toString(-32769));
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"21474836k");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)Long.toString(0x80000000L));
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)Long.toString(-2147483649L));
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)"10000000T");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE).toString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Long cfr_ignored_0 = (Long)ConfigUtil.convertStringToObject(Long.TYPE, (String)BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE).toString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Float cfr_ignored_0 = (Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)BigDecimal.valueOf(3.4028234663852886E38).add(BigDecimal.ONE).toPlainString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Float cfr_ignored_0 = (Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)BigDecimal.valueOf(3.4028234663852886E38).negate().subtract(BigDecimal.ONE).toPlainString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)BigDecimal.valueOf(Double.MAX_VALUE).add(BigDecimal.ONE).toPlainString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)BigDecimal.valueOf(Double.MAX_VALUE).negate().subtract(BigDecimal.ONE).toPlainString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Float cfr_ignored_0 = (Float)ConfigUtil.convertStringToObject(Float.TYPE, (String)BigDecimal.valueOf(Float.MIN_VALUE).divide(BigDecimal.valueOf(1.1), 46, RoundingMode.HALF_UP).toPlainString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)BigDecimal.valueOf(Double.MIN_VALUE).divide(BigDecimal.valueOf(1.1), 325, RoundingMode.HALF_UP).toPlainString());
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"-");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"+");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)".");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Double cfr_ignored_0 = (Double)ConfigUtil.convertStringToObject(Double.TYPE, (String)"123.456.789");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"0x10");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"-0x10");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"+0x10");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1kk");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"1k2");
        });
        Assert.assertThrows(InvalidFormatException.class, () -> {
            Integer cfr_ignored_0 = (Integer)ConfigUtil.convertStringToObject(Integer.TYPE, (String)"k");
        });
    }
}

