/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.IndexedSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.junit.Assert;
import org.junit.Test;

public class IndexerSerializationTest {
    private static final String INDEXED_OBJECTS_FILE = "indexed-objects.bin";
    private static final String DEFAULT_INDEXER_FUNCTION_CNAME = "com.devexperts.util.IndexerFunction$DefaultIndexerFunction";

    public static void main(String[] args) throws IOException {
        try (FileOutputStream os = new FileOutputStream("./dxlib/src/test/resources/indexed-objects.bin");
             ObjectOutputStream oos = new ObjectOutputStream(os);){
            IndexerSerializationTest.serializeObjects(oos);
        }
    }

    @Test
    public void testOldDeserialization() throws IOException, ClassNotFoundException {
        try (InputStream is = this.getClass().getResourceAsStream("/indexed-objects.bin");
             ObjectInputStream ois = new ObjectInputStream(is);){
            this.deserializeAndCheckObjects(ois);
        }
    }

    @Test
    public void testNewSerialization() throws IOException, ClassNotFoundException {
        byte[] bytes;
        Throwable throwable;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            throwable = null;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                IndexerSerializationTest.serializeObjects(oos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            bytes = baos.toByteArray();
        }
        var3_2 = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            throwable = null;
            try (ObjectInputStream ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (desc.getName().equals(IndexerSerializationTest.DEFAULT_INDEXER_FUNCTION_CNAME)) {
                        Assert.fail((String)"com.devexperts.util.IndexerFunction$DefaultIndexerFunction encountered in serialized data");
                    }
                    return super.resolveClass(desc);
                }
            };){
                this.deserializeAndCheckObjects(ois);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var3_2 = throwable4;
            throw throwable4;
        }
    }

    private void deserializeAndCheckObjects(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object obj = ois.readObject();
        Assert.assertTrue((boolean)(obj instanceof IndexedSet));
        IndexedSet set = (IndexedSet)obj;
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertEquals((Object)"xxx", (Object)set.getByKey((Object)"xxx"));
        Assert.assertEquals((Object)"yyy", (Object)set.getByKey((Object)"yyy"));
        Assert.assertEquals((Object)"com.devexperts.util.Indexer$DefaultIndexer", (Object)set.getIndexerFunction().getClass().getName());
    }

    private static void serializeObjects(ObjectOutputStream oos) throws IOException {
        IndexedSet set = new IndexedSet();
        set.add((Object)"xxx");
        set.add((Object)"yyy");
        oos.writeObject(set);
    }
}

