/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.WideDecimal;
import org.junit.Assert;
import org.junit.Test;

public class WideDecimalTest {
    private static final long MAX_SIGNIFICAND = 0x7FFFFFFFFFFFFFL;
    private static final int MAX_RANK = 255;

    @Test
    public void testSigns() {
        for (long significand = 0L; significand <= 0x7FFFFFFFFFFFFFL; significand += significand / 2L + 1L) {
            for (int rank = 0; rank <= 255; rank += 16) {
                long rawWide = significand << 8 | (long)(rank & 0xFF);
                long rawNeg = -significand << 8 | (long)(rank & 0xFF);
                Assert.assertEquals((long)rawWide, (long)WideDecimal.abs((long)rawWide));
                Assert.assertEquals((long)rawNeg, (long)WideDecimal.neg((long)rawWide));
            }
        }
    }

    @Test
    public void testWide() {
        this.checkWide("NaN", 0L, 128);
        this.checkWide("Infinity", 1L, 128);
        this.checkWide("Infinity", 123456L, 128);
        this.checkWide("-Infinity", -1L, 128);
        this.checkWide("-Infinity", -123456L, 128);
        this.checkWide("0", 0L, 0);
        this.checkWide("0", 0L, -10);
        this.checkWide("0", 0L, 10);
        this.checkWide("1", 1L, 0);
        this.checkWide("1", 1000L, -3);
        this.checkWide("1000000", 1000L, 3);
        this.checkWide("1000000", 1000000L, 0);
        this.checkWide("1000000", 1000000000L, -3);
        this.checkWide("1E7", 10000L, 3);
        this.checkWide("1E7", 10000000L, 0);
        this.checkWide("1E7", 10000000000L, -3);
        this.checkWide("123.456", 123456L, -3);
        this.checkWide("0.123456", 123456L, -6);
        this.checkWide("0.000123456", 123456L, -9);
        this.checkWide("0.000000123456", 123456L, -12);
        this.checkWide("1.23456E-8", 123456L, -13);
        this.checkWide("1.23456E-9", 123456L, -14);
        this.checkWide("1.23456E-10", 123456L, -15);
    }

    private void checkWide(String expected, long significand, int exponent) {
        double expectedDouble = Double.parseDouble(expected);
        long rawWide = significand << 8 | (long)(128 - exponent & 0xFF);
        long theWide = WideDecimal.composeWide((long)significand, (int)(-exponent));
        Assert.assertEquals((long)0L, (long)WideDecimal.compare((long)rawWide, (long)theWide));
        Assert.assertEquals((double)expectedDouble, (double)WideDecimal.toDouble((long)rawWide), (double)0.0);
        Assert.assertEquals((double)expectedDouble, (double)WideDecimal.toDouble((long)theWide), (double)0.0);
        Assert.assertEquals((Object)expected, (Object)WideDecimalTest.toString(rawWide));
        Assert.assertEquals((Object)expected, (Object)WideDecimalTest.toString(theWide));
        Assert.assertEquals((Object)expected, (Object)WideDecimalTest.toStringSB(rawWide));
        Assert.assertEquals((Object)expected, (Object)WideDecimalTest.toStringSB(theWide));
    }

    @Test
    public void testRandom() {
        for (int i = 0; i < 1000; ++i) {
            long pa = (long)Math.pow(10.0, (int)(Math.random() * 12.0));
            long pb = (long)Math.pow(10.0, (int)(Math.random() * 12.0));
            double a = Math.floor(Math.random() * (double)pa) / (double)pa;
            double b = Math.floor(Math.random() * (double)pb) / (double)pb;
            long wa = WideDecimal.composeWide((double)a);
            long wb = WideDecimal.composeWide((double)b);
            Assert.assertEquals((double)a, (double)WideDecimal.toDouble((long)wa), (double)0.0);
            Assert.assertEquals((double)b, (double)WideDecimal.toDouble((long)wb), (double)0.0);
            Assert.assertEquals((long)Double.compare(a, b), (long)WideDecimal.compare((long)wa, (long)wb));
            Assert.assertEquals((double)(a + b), (double)WideDecimal.toDouble((long)WideDecimal.sum((long)wa, (long)wb)), (double)1.0E-15);
        }
    }

    private static String toString(long wide) {
        return WideDecimal.toString((long)wide);
    }

    private static String toStringSB(long wide) {
        return WideDecimal.appendTo((StringBuilder)new StringBuilder(), (long)wide).toString();
    }
}

