/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.IOUtil;
import com.devexperts.io.SerialClassContext;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.junit.Assert;
import org.junit.Test;

public class SerialClassContextTest {
    @Test
    public void testEmptySerialContext() {
        SerialClassContext context1 = SerialClassContext.createSerialClassContext(null, null, null);
        SerialClassContext context2 = SerialClassContext.createSerialClassContext(null, Collections.singleton("*"), null);
        SerialClassContext context3 = SerialClassContext.createSerialClassContext(null, null, Collections.singleton(""));
        SerialClassContext context4 = SerialClassContext.createSerialClassContext(null, Collections.singleton("*"), Collections.singleton(""));
        Assert.assertEquals((Object)context1, (Object)context2);
        Assert.assertEquals((Object)context1, (Object)context3);
        Assert.assertEquals((Object)context1, (Object)context4);
        this.checkEmpty(context1);
        this.checkEmpty(context2);
        this.checkEmpty(context3);
        this.checkEmpty(context4);
    }

    private void checkEmpty(SerialClassContext context) {
        Assert.assertEquals(Collections.singletonList("*"), (Object)context.getWhitelist());
        Assert.assertTrue((boolean)context.getBlacklist().isEmpty());
        this.checkAccept(context, Class.class.getName());
        this.checkAccept(context, IOUtil.class.getName());
        this.checkAccept(context, ClassLoader.class.getName());
    }

    @Test
    public void testAddWhiteAndBlackClasses() {
        String c1 = List.class.getName();
        String c2 = Executor.class.getName();
        SerialClassContext context = this.get(null, null);
        this.checkAccept(context, c1);
        this.checkAccept(context, c2);
        context = this.get(c1, "");
        this.checkAccept(context, c1);
        this.checkReject(context, c2, "whitelist");
        context = this.get(c1 + ",java.*", "");
        this.checkAccept(context, c1);
        this.checkAccept(context, c2);
        context = this.get(c1 + ",java.*", c1);
        this.checkReject(context, c1, "blacklist");
        this.checkAccept(context, c2);
        context = this.get(c1 + ",java.*", c1 + ",java.*");
        this.checkReject(context, c1, "blacklist");
        this.checkReject(context, c2, "blacklist");
    }

    private SerialClassContext get(String whitelist, String blacklist) {
        List<String> whiteClasses = whitelist == null ? null : Arrays.asList(whitelist.split(","));
        List<String> blackClasses = blacklist == null ? null : Arrays.asList(blacklist.split(","));
        return SerialClassContext.createSerialClassContext(null, whiteClasses, blackClasses);
    }

    private void checkAccept(SerialClassContext context, String className) {
        Assert.assertTrue((boolean)context.accept(className));
        try {
            context.check(className);
        }
        catch (Throwable t) {
            Assert.fail();
        }
    }

    private void checkReject(SerialClassContext context, String className, String listName) {
        Assert.assertFalse((boolean)context.accept(className));
        try {
            context.check(className);
            Assert.fail();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)(t instanceof ClassNotFoundException));
            Assert.assertTrue((boolean)t.getMessage().contains(listName));
        }
    }

    @Test
    public void testDifferentClassLoader() {
        ClassLoader loader1 = this.getClass().getClassLoader();
        URLClassLoader loader2 = new URLClassLoader(new URL[0]);
        URLClassLoader loader3 = new URLClassLoader(new URL[0]);
        Assert.assertNotEquals((Object)SerialClassContextTest.getDefault(loader1), (Object)SerialClassContextTest.getDefault(loader2));
        Assert.assertNotEquals((Object)SerialClassContextTest.getDefault(loader1), (Object)SerialClassContextTest.getDefault(loader3));
        Assert.assertNotEquals((Object)SerialClassContextTest.getDefault(loader2), (Object)SerialClassContextTest.getDefault(loader3));
        Assert.assertEquals((Object)SerialClassContextTest.getDefault(loader1), (Object)SerialClassContextTest.getDefault(loader1));
        Assert.assertEquals((Object)SerialClassContextTest.getDefault(loader2), (Object)SerialClassContextTest.getDefault(loader2));
        Assert.assertEquals((Object)SerialClassContextTest.getDefault(loader3), (Object)SerialClassContextTest.getDefault(loader3));
    }

    private static SerialClassContext getDefault(ClassLoader cl) {
        return SerialClassContext.getDefaultSerialContext((ClassLoader)cl);
    }
}

