/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.test;

import com.devexperts.logging.TraceLogging;
import com.devexperts.test.TraceRunner;
import java.io.PrintStream;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
class TraceListener
extends RunListener {
    TraceListener() {
    }

    public void testStarted(Description description) throws Exception {
        TraceLogging.restart();
    }

    public void testFailure(Failure f) throws Exception {
        TraceLogging.logAndStop(TraceRunner.class, (String)("Test stopped with failure: " + f.getMessage()), (Throwable)f.getException());
        this.dump(f.getDescription());
    }

    public void testFinished(Description description) throws Exception {
        TraceLogging.stop();
        if (TraceRunner.DUMP_ALWAYS) {
            this.dump(description);
        }
    }

    private void dump(Description description) {
        TraceLogging.dump((PrintStream)System.out, (String)description.getDisplayName());
    }
}

