/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexedSetStats;
import com.devexperts.util.IndexerFunction;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StressTestIndexedSet<K> {
    private static final IndexerFunction<Long, Integer> LONG_INDEXER = new IndexerFunction.LongKey<Integer>(){

        public long getNumberKey(Integer value) {
            return value.intValue();
        }

        public String toString() {
            return "LONG_INDEXER";
        }
    };
    private static final IndexerFunction<String, Integer> STRING_INDEXER = new IndexerFunction<String, Integer>(){

        public String getObjectKey(Integer value) {
            return value.toString();
        }

        public String toString() {
            return "STRING_INDEXER";
        }
    };
    private final Map<K, Integer> map;
    private final IndexerFunction<K, Integer> indexer;
    private int maxAllocatedSize;
    private double maxAverageDistance;
    private double sumAverageDistance;
    private double maxAmortizedCost;
    private double sumAmortizedCost;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException {
        void var2_7;
        List<Integer> ids = StressTestIndexedSet.load(args[0]);
        if (args.length > 1) {
            String type = args[1];
            if (type.equalsIgnoreCase("string")) {
                StressTestIndexedSet<String> stressTestIndexedSet = new StressTestIndexedSet<String>(StressTestIndexedSet.convertToStrs(ids), STRING_INDEXER);
            } else {
                if (!type.toLowerCase(Locale.US).startsWith("bad")) throw new IllegalArgumentException(type);
                int badness = Integer.parseInt(type.substring(3));
                StressTestIndexedSet<Long> stressTestIndexedSet = new StressTestIndexedSet<Long>(StressTestIndexedSet.convertToLongs(ids), (IndexerFunction<Long, Integer>)new BadIndexer(badness));
            }
        } else {
            StressTestIndexedSet<Long> stressTestIndexedSet = new StressTestIndexedSet<Long>(StressTestIndexedSet.convertToLongs(ids), LONG_INDEXER);
        }
        super.go();
    }

    private static Map<Long, Integer> convertToLongs(List<Integer> ids) {
        LinkedHashMap<Long, Integer> result = new LinkedHashMap<Long, Integer>();
        for (Integer id : ids) {
            result.put(id.longValue(), id);
        }
        return result;
    }

    private static Map<String, Integer> convertToStrs(List<Integer> ids) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Integer id : ids) {
            result.put(id.toString(), id);
        }
        return result;
    }

    private static List<Integer> load(String fileName) throws IOException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try {
            int i = Integer.parseInt(fileName);
            while (--i >= 0) {
                ids.add((int)(2.147483647E9 * Math.random()));
            }
            System.out.println("Generated " + ids.size() + " ids");
            return ids;
        }
        catch (NumberFormatException i) {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            while ((line = in.readLine()) != null) {
                ids.add(Integer.parseInt(line.trim()));
            }
            in.close();
            System.out.println("Loaded " + ids.size() + " ids from \"" + fileName + "\"");
            return ids;
        }
    }

    public StressTestIndexedSet(Map<K, Integer> map, IndexerFunction<K, Integer> indexer) {
        this.map = map;
        this.indexer = indexer;
    }

    private void go() {
        System.out.println("Testing with " + this.indexer);
        int i = 1;
        while (true) {
            this.performTest(i);
            ++i;
        }
    }

    private void performTest(int i) {
        ArrayList<Integer> values = new ArrayList<Integer>(this.map.values());
        Collections.shuffle(values);
        IndexedSet set = IndexedSet.create(this.indexer);
        set.addAll(values);
        IndexedSetStats stats = set.getStats();
        for (Map.Entry<K, Integer> entry : this.map.entrySet()) {
            if (set.getByKey(entry.getKey()) != entry.getValue()) {
                throw new AssertionError((Object)("Structure is broken at " + entry.getKey() + " with " + stats));
            }
        }
        this.sumAverageDistance += stats.getAverageDistance();
        this.sumAmortizedCost += stats.getAmortizedCost();
        if (i % 10 == 0 || stats.getAllocatedSize() > this.maxAllocatedSize || stats.getAverageDistance() > this.maxAverageDistance || stats.getAmortizedCost() > this.maxAmortizedCost) {
            this.maxAllocatedSize = Math.max(this.maxAllocatedSize, stats.getAllocatedSize());
            this.maxAverageDistance = Math.max(this.maxAverageDistance, stats.getAverageDistance());
            this.maxAmortizedCost = Math.max(this.maxAmortizedCost, stats.getAmortizedCost());
            System.out.printf(Locale.US, "%d: %s [overall avgdist %.3f, amortized %.3f]%n", i, stats, this.sumAverageDistance / (double)i, this.sumAmortizedCost / (double)i);
        }
    }

    private static class BadIndexer
    implements IndexerFunction.LongKey<Integer> {
        private final int badness;

        BadIndexer(int badness) {
            this.badness = badness;
        }

        public int hashCodeByValue(Integer value) {
            return value / this.badness;
        }

        public int hashCodeByKey(Long key) {
            return (int)(key / (long)this.badness);
        }

        public long getNumberKey(Integer value) {
            return value.intValue();
        }

        public String toString() {
            return "BAD_INDEXER[" + this.badness + "]";
        }
    }
}

