/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.transport;

import com.devexperts.connector.proto.AbstractTransportConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.logging.Logging;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketApplicationConnection;
import com.devexperts.qd.dxlink.websocket.transport.DxLinkClientWebSocketConnector;
import com.devexperts.qd.dxlink.websocket.transport.SocketState;
import com.devexperts.qd.dxlink.websocket.transport.WebSocketWriter;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.transport.stats.ConnectionStats;
import com.devexperts.util.JMXNameBuilder;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

class WebSocketTransportConnection
extends AbstractTransportConnection
implements AbstractMessageConnector.Joinable {
    private static final String VERBOSE = SystemProperties.getProperty((String)"com.devexperts.qd.qtp.socket.verbose", null);
    private static final int MAX_TEXT_MESSAGE_BUFFER_SIZE = SystemProperties.getIntProperty((String)"com.devexperts.qd.dxlink.websocket.maxTextMessageBufferSize", (int)65536);
    public static final int MAX_FRAME_PAYLOAD_LENGTH = SystemProperties.getIntProperty((String)"com.devexperts.qd.dxlink.websocket.maxFramePayloadLength", (int)65536);
    private static final long CONNECT_TIMEOUT = TimePeriod.valueOf((String)SystemProperties.getProperty((String)"com.devexperts.qd.dxlink.websocket.connectTimeout", (String)"5m")).getTime();
    public static final long HANDSHAKE_TIMEOUT = TimePeriod.valueOf((String)SystemProperties.getProperty((String)"com.devexperts.qd.dxlink.websocket.handshakeTimeout", (String)"10s")).getTime();
    private static final String WS_EXTENSIONS = "ws_extensions";
    private final Logging log;
    private final DxLinkClientWebSocketConnector connector;
    final boolean verbose;
    private final String address;
    private WebSocketWriter writer;
    private EventLoopGroup socketThread;
    private volatile Session session;
    private volatile CloseListener closeListener;
    private volatile SocketState state = SocketState.NEW;

    WebSocketTransportConnection(DxLinkClientWebSocketConnector connector, String address) {
        this.connector = connector;
        this.log = connector.getLogging();
        this.address = address;
        this.verbose = VERBOSE != null && connector.getName().contains(VERBOSE);
    }

    public MessageConnectorState getHandlerState() {
        return this.state.state;
    }

    public boolean isConnected() {
        return this.state == SocketState.CONNECTED;
    }

    ConnectionStats getActiveConnectionStats() {
        Session threadData = this.session;
        return threadData == null ? null : threadData.connectionStats;
    }

    public void setCloseListener(CloseListener listener) {
        this.closeListener = listener;
    }

    public synchronized void start() {
        if (this.state != SocketState.NEW) {
            return;
        }
        this.state = SocketState.STARTED;
        this.writer = new WebSocketWriter(this);
        this.writer.setPriority(this.connector.getThreadPriority());
        this.writer.start();
        this.socketThread = new OioEventLoopGroup();
        ((Object)((Object)this)).notifyAll();
    }

    public void close() {
        this.exitSocket(null);
    }

    public void join() throws InterruptedException {
        this.writer.join();
        if (!this.socketThread.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
            throw new InterruptedException();
        }
    }

    public void exitSocket(Throwable reason) {
        CloseListener listener;
        if (!this.makeClosedAndStopThread()) {
            return;
        }
        Session session = this.session;
        if (session != null) {
            this.session = null;
            session.close(reason);
        }
        if ((listener = this.closeListener) != null) {
            listener.handlerClosed(this);
        }
        this.connector.notifyMessageConnectorListeners();
    }

    public void stopConnector() {
        this.connector.stop();
    }

    public String toString() {
        return this.address;
    }

    Session createSession() throws InterruptedException {
        Address adr;
        if (!this.makeConnecting()) {
            return this.waitConnected();
        }
        this.connector.notifyMessageConnectorListeners();
        if (this.address == null) {
            return null;
        }
        this.connector.getReconnectHelper().sleepBeforeConnection();
        this.log.info("Connecting to " + LogUtil.hideCredentials((Object)this.address));
        try {
            adr = new Address(this.address);
            this.variables().set(REMOTE_HOST_ADDRESS_KEY, (Object)this.address);
        }
        catch (URISyntaxException | SSLException e) {
            throw new RuntimeException("Failed to connect to " + LogUtil.hideCredentials((Object)this.address), e);
        }
        final Session session = new Session();
        try {
            final ChannelPromise[] handshakeFuture = new ChannelPromise[1];
            ChannelInitializer<SocketChannel> channelInitializer = new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (adr.sslCtx != null) {
                        pipeline.addLast(new ChannelHandler[]{adr.sslCtx.newHandler(ch.alloc(), adr.host, adr.port)});
                    }
                    DefaultHttpHeaders headers = new DefaultHttpHeaders();
                    headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)QDFactory.getVersion().replace('-', '/').replace('+', ' '));
                    WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)adr.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)headers, (int)MAX_FRAME_PAYLOAD_LENGTH);
                    pipeline.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(MAX_TEXT_MESSAGE_BUFFER_SIZE), WebSocketClientCompressionHandler.INSTANCE, new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (msg instanceof FullHttpResponse) {
                                FullHttpResponse response = (FullHttpResponse)msg;
                                String extensions = response.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                                ctx.channel().attr(AttributeKey.valueOf((String)WebSocketTransportConnection.WS_EXTENSIONS)).set((Object)extensions);
                            }
                            super.channelRead(ctx, msg);
                        }
                    }, new WebSocketClientProtocolHandler(handshaker, false), new WebSocketChannelInboundHandler(handshakeFuture, session)});
                }
            };
            ChannelFuture connect = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.socketThread)).channel(OioSocketChannel.class)).handler((ChannelHandler)channelInitializer)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)CONNECT_TIMEOUT))).connect(adr.host, adr.port);
            WebSocketTransportConnection.wait(connect, CONNECT_TIMEOUT);
            WebSocketTransportConnection.wait((ChannelFuture)handshakeFuture[0], HANDSHAKE_TIMEOUT);
            session.channel = connect.channel();
        }
        catch (Throwable e) {
            session.close(e);
            throw new RuntimeException("Failed to connect to " + LogUtil.hideCredentials((Object)this.address), e);
        }
        boolean connected = this.makeConnected(session);
        if (!connected) {
            session.close(null);
            return null;
        }
        this.connector.notifyMessageConnectorListeners();
        return session;
    }

    private static void wait(ChannelFuture future, long timeoutInMs) throws IOException {
        future.awaitUninterruptibly(timeoutInMs, TimeUnit.MILLISECONDS);
        if (future.isCancelled()) {
            throw new SocketTimeoutException();
        }
        if (!future.isSuccess()) {
            throw new IOException(future.cause().getMessage(), future.cause());
        }
    }

    private DxLinkWebSocketApplicationConnection createApplicationConnection(QDStats stats) {
        DxLinkWebSocketApplicationConnection connection = null;
        Throwable failureReason = null;
        try {
            ApplicationConnectionFactory acf = this.connector.getFactory();
            connection = (DxLinkWebSocketApplicationConnection)acf.createConnection((TransportConnection)this);
        }
        catch (Throwable t) {
            failureReason = t;
        }
        if (connection == null) {
            this.log.error("Failed to create connection on socket " + LogUtil.hideCredentials((Object)this.address), failureReason);
            try {
                stats.close();
            }
            catch (Throwable t) {
                this.log.error("Failed to close stats", t);
            }
            this.connector.addClosedConnectionStats(new ConnectionStats());
            throw new RuntimeException(failureReason);
        }
        connection.start();
        return connection;
    }

    private QDStats createStats() {
        try {
            URI uri = new URI(this.address);
            QDStats stats = this.connector.getStats().getOrCreate(QDStats.SType.CONNECTIONS).create(QDStats.SType.CONNECTION, "host=" + JMXNameBuilder.quoteKeyPropertyValue((String)uri.getHost()) + ",port=" + uri.getPort() + ",localPort=" + -1);
            if (stats == null) {
                throw new NullPointerException("Stats were not created");
            }
            return stats;
        }
        catch (Throwable t) {
            this.log.error("Failed to configure socket " + LogUtil.hideCredentials((Object)this.address), t);
            this.connector.addClosedConnectionStats(new ConnectionStats());
            throw new RuntimeException(t);
        }
    }

    private synchronized boolean makeConnecting() {
        if (this.state == SocketState.STARTED) {
            this.state = SocketState.CONNECTING;
            ((Object)((Object)this)).notifyAll();
            return true;
        }
        return false;
    }

    private synchronized boolean makeConnected(Session sessionData) {
        if (this.state == SocketState.CONNECTING) {
            this.state = SocketState.CONNECTED;
            this.session = sessionData;
            ((Object)((Object)this)).notifyAll();
            return true;
        }
        return false;
    }

    private synchronized Session waitConnected() throws InterruptedException {
        while (this.state == SocketState.CONNECTING) {
            ((Object)((Object)this)).wait();
        }
        if (this.state == SocketState.CONNECTED) {
            return this.session;
        }
        if (this.state == SocketState.STOPPED) {
            return null;
        }
        throw new IllegalStateException();
    }

    private synchronized boolean makeClosedAndStopThread() {
        if (this.state == SocketState.STOPPED) {
            return false;
        }
        if (this.state != SocketState.NEW) {
            this.writer.close();
            this.socketThread.shutdownGracefully();
        }
        this.state = SocketState.STOPPED;
        ((Object)((Object)this)).notifyAll();
        return true;
    }

    public void markForImmediateRestart() {
        this.connector.getReconnectHelper().reset();
    }

    public void connectionClosed() {
        this.close();
    }

    public void chunksAvailable() {
        this.writer.chunksAvailable();
    }

    public void readyToProcessChunks() {
    }

    private class WebSocketChannelInboundHandler
    extends SimpleChannelInboundHandler<Object> {
        private final ChannelPromise[] handshakeFuture;
        private final Session session;

        private WebSocketChannelInboundHandler(ChannelPromise[] handshakeFuture, Session session) {
            this.handshakeFuture = handshakeFuture;
            this.session = session;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.handshakeFuture[0] = ctx.newPromise();
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            WebSocketTransportConnection.this.close();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                try {
                    Channel ch = ctx.channel();
                    this.session.stats = WebSocketTransportConnection.this.createStats();
                    WebSocketTransportConnection.this.variables().set(MessageConnectors.STATS_KEY, (Object)this.session.stats);
                    this.session.application = WebSocketTransportConnection.this.createApplicationConnection(this.session.stats);
                    this.handshakeFuture[0].setSuccess();
                    String secWebSocketExtensions = (String)ctx.channel().attr(AttributeKey.valueOf((String)WebSocketTransportConnection.WS_EXTENSIONS)).get();
                    WebSocketTransportConnection.this.log.info("Connected to " + LogUtil.hideCredentials((Object)WebSocketTransportConnection.this.address) + ", host=" + ch.remoteAddress().toString() + ", sec extensions=" + secWebSocketExtensions);
                }
                catch (Throwable e) {
                    this.handshakeFuture[0].setFailure(e);
                    throw new IOException(e);
                }
            }
            super.userEventTriggered(ctx, evt);
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                if (WebSocketTransportConnection.this.verbose && WebSocketTransportConnection.this.log.debugEnabled()) {
                    WebSocketTransportConnection.this.log.debug("RCVD: " + textFrame.text());
                }
                this.session.application.processMessage(textFrame.text());
            } else if (frame instanceof CloseWebSocketFrame) {
                ctx.channel().close();
                WebSocketTransportConnection.this.exitSocket(new EOFException());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
            if (!this.handshakeFuture[0].isDone()) {
                this.handshakeFuture[0].setFailure(cause);
            }
            WebSocketTransportConnection.this.exitSocket(cause);
        }
    }

    private static class Address {
        private final URI uri;
        private final String host;
        private final int port;
        private final SslContext sslCtx;

        private Address(String address) throws URISyntaxException, SSLException {
            this.uri = new URI(address);
            if (!"ws".equalsIgnoreCase(this.uri.getScheme()) && !"wss".equalsIgnoreCase(this.uri.getScheme())) {
                throw new IllegalArgumentException("Only WS(S) is supported.");
            }
            if (this.uri.getHost() == null) {
                throw new IllegalArgumentException("No host name specified");
            }
            this.host = this.uri.getHost();
            this.port = this.uri.getPort() == -1 ? ("ws".equalsIgnoreCase(this.uri.getScheme()) ? WebSocketScheme.WS.port() : ("wss".equalsIgnoreCase(this.uri.getScheme()) ? WebSocketScheme.WSS.port() : this.uri.getPort())) : this.uri.getPort();
            this.sslCtx = "wss".equalsIgnoreCase(this.uri.getScheme()) ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        }
    }

    class Session {
        Channel channel;
        DxLinkWebSocketApplicationConnection application;
        QDStats stats;
        ConnectionStats connectionStats = new ConnectionStats();

        Session() {
        }

        public void writeAndFlush(ByteBuf message) {
            if (WebSocketTransportConnection.this.verbose && WebSocketTransportConnection.this.log.debugEnabled()) {
                WebSocketTransportConnection.this.log.debug("SNT: " + message.toString(StandardCharsets.UTF_8));
            }
            this.channel.writeAndFlush((Object)new TextWebSocketFrame(message));
            this.connectionStats.addWrittenBytes((long)message.readableBytes());
        }

        public void close(Throwable reason) {
            try {
                if (this.application != null) {
                    this.application.close();
                }
            }
            catch (Throwable t) {
                WebSocketTransportConnection.this.log.error("Failed to close connection", t);
            }
            try {
                if (this.stats != null) {
                    this.stats.close();
                }
            }
            catch (Throwable t) {
                WebSocketTransportConnection.this.log.error("Failed to close stats", t);
            }
            WebSocketTransportConnection.this.connector.addClosedConnectionStats(this.connectionStats);
            if (this.channel != null) {
                if (reason != null) {
                    try {
                        String errorJson = String.format("{\"type\":\"ERROR\",\"channel\":0,\"error\":\"UNKNOWN\",\"message\":\"%s\"}", reason.getMessage());
                        this.writeAndFlush(Unpooled.copiedBuffer((byte[])errorJson.getBytes(StandardCharsets.UTF_8)));
                    }
                    catch (Throwable t) {
                        WebSocketTransportConnection.this.log.error("Error occurred while sending an error to " + LogUtil.hideCredentials((Object)WebSocketTransportConnection.this.address), t);
                    }
                }
                try {
                    this.channel.close();
                    if (reason == null || reason instanceof IOException) {
                        WebSocketTransportConnection.this.log.info("Disconnected from " + LogUtil.hideCredentials((Object)WebSocketTransportConnection.this.address) + (reason == null ? "" : " because of " + (reason.getMessage() == null ? reason.toString() : reason.getMessage())));
                    } else {
                        WebSocketTransportConnection.this.log.error("Disconnected from " + LogUtil.hideCredentials((Object)WebSocketTransportConnection.this.address), reason);
                    }
                }
                catch (Throwable t) {
                    WebSocketTransportConnection.this.log.error("Error occurred while disconnecting from " + LogUtil.hideCredentials((Object)WebSocketTransportConnection.this.address), t);
                }
            }
        }
    }

    public static interface CloseListener {
        public void handlerClosed(AbstractTransportConnection var1);
    }
}

