/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.application;

import com.devexperts.logging.Logging;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.services.Services;
import com.devexperts.util.IndexedSet;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateSet;
import com.dxfeed.event.EventType;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.market.OrderSource;
import com.fasterxml.jackson.core.JsonParser;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.Introspector;
import com.googlecode.openbeans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

final class Delegates {
    private static final Logging log = Logging.getLogging(Delegates.class);
    private static final VoidSetter VOID_SETTER = new VoidSetter();
    private final IndexedSet<Class<?>, EventDelegateSet<EventType<?>, EventDelegate<EventType<?>>>> delegateSetsByEventType = IndexedSet.create(EventDelegateSet::eventType);
    IndexedSet<String, EventBuilder> builderByEventType = IndexedSet.create(EventBuilder::eventType);

    Delegates(DataScheme scheme) {
        for (EventDelegateFactory factory : Services.createServices(EventDelegateFactory.class, null)) {
            for (int i = 0; i < scheme.getRecordCount(); ++i) {
                DataRecord record = scheme.getRecord(i);
                Collection delegates = factory.createDelegates(record);
                if (delegates == null) continue;
                delegates.forEach(delegate -> {
                    EventDelegateSet delegateSet = (EventDelegateSet)this.delegateSetsByEventType.getByKey((Object)delegate.getEventType());
                    if (delegateSet == null) {
                        delegateSet = delegate.createDelegateSet();
                        this.delegateSetsByEventType.add((Object)delegateSet);
                    }
                    delegateSet.add(delegate);
                });
            }
        }
        for (EventDelegateSet delegateSet : this.delegateSetsByEventType) {
            delegateSet.completeConstruction();
            this.builderByEventType.add((Object)new EventBuilder(delegateSet.eventType().getSimpleName(), () -> ((EventDelegate)((EventDelegate)delegateSet.getAllPubDelegates().get(0))).createEvent(), Delegates.createSetters(((EventDelegate)delegateSet.getAllPubDelegates().get(0)).createEvent())));
        }
    }

    void putEventToRecordBuffer(EventType<?> event, QDContract qdContract, RecordBuffer recordBuffer) {
        EventDelegateSet delegateSet = (EventDelegateSet)this.delegateSetsByEventType.getByKey(event.getClass());
        List delegates = delegateSet.getPubDelegatesByEvent(event);
        for (EventDelegate delegate : delegates) {
            if (delegate.getContract() != qdContract) continue;
            delegate.putEvent(event, recordBuffer);
        }
    }

    EventBuilder getEventBuilder(String eventType, List<String> fields) {
        EventBuilder eventBuilder = (EventBuilder)this.builderByEventType.getByKey((Object)eventType);
        if (eventBuilder == null) {
            log.warn(String.format("Unknown event type: '%s'.", eventType));
            LinkedHashMap<String, VoidSetter> setters = new LinkedHashMap<String, VoidSetter>();
            for (String field : fields) {
                setters.put(field, VOID_SETTER);
            }
            return new EventBuilder(eventType, () -> null, setters);
        }
        LinkedHashMap<String, Setter> setters = new LinkedHashMap<String, Setter>();
        for (String field : fields) {
            setters.put(field, eventBuilder.setters.getOrDefault(field, VOID_SETTER));
        }
        return new EventBuilder(eventType, eventBuilder.factory, setters);
    }

    Map<String, List<String>> fieldsByEventType() {
        HashMap<String, List<String>> fieldsByEventType = new HashMap<String, List<String>>();
        for (EventBuilder builder : this.builderByEventType) {
            fieldsByEventType.put(builder.eventType(), new ArrayList<String>(builder.setters.keySet()));
        }
        return fieldsByEventType;
    }

    private static LinkedHashMap<String, Setter> createSetters(EventType<?> event) {
        try {
            LinkedHashMap<String, Setter> setters = new LinkedHashMap<String, Setter>();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(event.getClass()).getPropertyDescriptors()) {
                Method writeMethod;
                Method readMethod = pd.getReadMethod();
                if (Delegates.isTransientField(readMethod, writeMethod = pd.getWriteMethod())) continue;
                String name = Delegates.extractFieldName(pd, readMethod);
                Class<?> parameterType = writeMethod.getParameterTypes()[0];
                if (parameterType == Double.TYPE) {
                    setters.put(name, new DoubleSetter(writeMethod));
                    continue;
                }
                if (parameterType == Long.TYPE) {
                    setters.put(name, new LongSetter(writeMethod));
                    continue;
                }
                if (parameterType == Integer.TYPE) {
                    setters.put(name, new IntegerSetter(writeMethod));
                    continue;
                }
                if (parameterType == String.class) {
                    setters.put(name, new StringSetter(writeMethod));
                    continue;
                }
                if (parameterType == Character.TYPE) {
                    setters.put(name, new CharSetter(writeMethod));
                    continue;
                }
                if (parameterType == Boolean.TYPE) {
                    setters.put(name, new BooleanSetter(writeMethod));
                    continue;
                }
                if (parameterType.isEnum()) {
                    setters.put(name, new EnumSetter(writeMethod, parameterType));
                    continue;
                }
                if (OrderSource.class.isAssignableFrom(parameterType)) {
                    setters.put(name, new OrderSourceSetter(writeMethod));
                    continue;
                }
                if ("eventSymbol".equals(name)) {
                    if (event.getClass().getSimpleName().contains("Candle")) {
                        setters.put(name, new CandleSymbolSetter(writeMethod));
                        continue;
                    }
                    setters.put(name, new StringSetter(writeMethod));
                    continue;
                }
                if ("attachment".equals(name)) {
                    setters.put(name, new StringSetter(writeMethod));
                    continue;
                }
                throw new IllegalStateException();
            }
            return setters;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isTransientField(Method readMethod, Method writeMethod) {
        return readMethod == null || readMethod.getAnnotation(XmlTransient.class) != null || writeMethod == null || writeMethod.getAnnotation(XmlTransient.class) != null;
    }

    private static String extractFieldName(PropertyDescriptor propertyDescriptor, Method readMethod) {
        XmlElement xmlElement = readMethod.getAnnotation(XmlElement.class);
        if (xmlElement != null && !xmlElement.name().equals("##default")) {
            return xmlElement.name();
        }
        return propertyDescriptor.getName();
    }

    static class EventBuilder {
        final String eventType;
        final Supplier<EventType<?>> factory;
        final LinkedHashMap<String, Setter> setters;

        private EventBuilder(String eventType, Supplier<EventType<?>> factory, LinkedHashMap<String, Setter> setters) {
            this.eventType = eventType;
            this.factory = factory;
            this.setters = setters;
        }

        public String eventType() {
            return this.eventType;
        }
    }

    private static final class DoubleSetter
    extends Setter {
        private DoubleSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return parser.getValueAsDouble();
        }
    }

    private static final class LongSetter
    extends Setter {
        private LongSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return parser.getValueAsLong();
        }
    }

    private static final class IntegerSetter
    extends Setter {
        private IntegerSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return parser.getValueAsInt();
        }
    }

    private static final class CharSetter
    extends Setter {
        private CharSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            String stringValue = parser.getValueAsString();
            return Character.valueOf(stringValue.isEmpty() ? (char)'\u0000' : stringValue.charAt(0));
        }
    }

    private static final class BooleanSetter
    extends Setter {
        private BooleanSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return parser.getValueAsBoolean();
        }
    }

    private static final class StringSetter
    extends Setter {
        private StringSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return parser.getValueAsString();
        }
    }

    private static final class OrderSourceSetter
    extends Setter {
        private OrderSourceSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return OrderSource.valueOf((String)parser.getValueAsString());
        }
    }

    private static final class CandleSymbolSetter
    extends Setter {
        private CandleSymbolSetter(Method setter) {
            super(setter);
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return CandleSymbol.valueOf((String)parser.getValueAsString());
        }
    }

    private static final class EnumSetter
    extends Setter {
        private final Class<? extends Enum> enumClazz;

        private EnumSetter(Method setter, Class<? extends Enum> enumClazz) {
            super(setter);
            this.enumClazz = enumClazz;
        }

        @Override
        protected Object value(JsonParser parser) throws IOException {
            return Enum.valueOf(this.enumClazz, parser.getValueAsString());
        }
    }

    static final class VoidSetter
    extends Setter {
        VoidSetter() {
            super(null);
        }

        @Override
        public void setValue(EventType<?> event, JsonParser fieldIterator) {
        }

        @Override
        protected Object value(JsonParser parser) {
            throw new IllegalStateException();
        }
    }

    static abstract class Setter {
        private final Method setter;

        private Setter(Method setter) {
            this.setter = setter;
        }

        public void setValue(EventType<?> event, JsonParser parser) throws IOException {
            try {
                this.setter.invoke(event, this.value(parser));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        protected abstract Object value(JsonParser var1) throws IOException;
    }
}

