/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.application;

import com.devexperts.logging.Logging;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.dxlink.websocket.application.ChannelEventsParser;
import com.devexperts.qd.dxlink.websocket.application.Delegates;
import com.devexperts.qd.dxlink.websocket.application.DxLinkClientReceiver;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DxLinkJsonMessageParser {
    public static final String COMPACT = "COMPACT";
    public static final String FULL = "FULL";
    private static final long WARN_TIMEOUT_NANOS = TimePeriod.valueOf((String)SystemProperties.getProperty((String)"com.devexperts.qd.qtp.socket.readerWarnTimeout", (String)"15s")).getNanos();
    private static final Logging log = Logging.getLogging(DxLinkJsonMessageParser.class);
    private final JsonFactory factory = JsonFactory.builder().build();
    private final Map<String, MessageParsingStrategy> strategies = new HashMap<String, MessageParsingStrategy>();
    private final Map<Integer, ChannelEventsParser> channelParsers = new HashMap<Integer, ChannelEventsParser>();
    private final DxLinkClientReceiver receiver;
    private final Delegates delegates;

    DxLinkJsonMessageParser(DxLinkClientReceiver receiver, Delegates delegates) {
        this.receiver = receiver;
        this.delegates = delegates;
        this.strategies.put("SETUP", this::parseSetup);
        this.strategies.put("ERROR", this::parseError);
        this.strategies.put("AUTH_STATE", this::parseAuthState);
        this.strategies.put("KEEPALIVE", this::parseKeepalive);
        this.strategies.put("CHANNEL_OPENED", this::parseChannelOpened);
        this.strategies.put("FEED_CONFIG", this::parseFeedConfig);
        this.strategies.put("FEED_DATA", this::parseFeedData);
    }

    private static Map<String, List<String>> parseEventFields(JsonParser parser) throws IOException {
        JsonToken jsonToken;
        HashMap<String, List<String>> eventFields;
        block6: {
            eventFields = new HashMap<String, List<String>>();
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IllegalStateException("The Json object must begin with '{'.");
            }
            block0: while (true) {
                if ((jsonToken = parser.nextValue()) == null) {
                    throw new IllegalStateException("Unexpected end of json.");
                }
                if (jsonToken != JsonToken.START_ARRAY) break block6;
                String eventType = parser.getCurrentName();
                ArrayList<String> fields = new ArrayList<String>();
                eventFields.put(eventType, fields);
                while (true) {
                    if ((jsonToken = parser.nextValue()) == null) {
                        throw new IllegalStateException("Unexpected end of json.");
                    }
                    if (jsonToken == JsonToken.END_ARRAY) continue block0;
                    if (jsonToken != JsonToken.VALUE_STRING) break block0;
                    fields.add(parser.getValueAsString());
                }
                break;
            }
            throw new IllegalStateException(String.format("Unexpected token: '%s'.", jsonToken.asString()));
        }
        if (jsonToken == JsonToken.END_OBJECT) {
            return eventFields;
        }
        throw new IllegalStateException(String.format("Unexpected token: '%s'.", jsonToken.asString()));
    }

    void read(String message) throws IOException {
        long timeNanos = System.nanoTime();
        try (JsonParser jsonParser = this.factory.createParser(message);){
            String type = null;
            int channel = -1;
            if (jsonParser.nextToken() != JsonToken.START_OBJECT) {
                throw new IllegalStateException("The Json object must begin with '{'.");
            }
            jsonParser.nextValue();
            if ("type".equals(jsonParser.currentName())) {
                type = jsonParser.getValueAsString();
            } else if ("channel".equals(jsonParser.currentName())) {
                channel = jsonParser.getValueAsInt();
            } else {
                throw new IllegalStateException("The first two fields must be 'type' and 'channel'.");
            }
            jsonParser.nextValue();
            if ("type".equals(jsonParser.currentName())) {
                type = jsonParser.getValueAsString();
            } else if ("channel".equals(jsonParser.currentName())) {
                channel = jsonParser.getValueAsInt();
            } else {
                throw new IllegalStateException("The first two fields must be 'type' and 'channel'.");
            }
            MessageParsingStrategy parsingStrategy = this.strategies.get(type);
            if (parsingStrategy == null) {
                log.warn("Unknown message type: '" + type + "'");
            } else {
                parsingStrategy.process(channel, jsonParser);
            }
        }
        long deltaTimeNanos = System.nanoTime() - timeNanos;
        if (deltaTimeNanos > WARN_TIMEOUT_NANOS) {
            log.warn("processChunks took " + deltaTimeNanos + " ns");
        }
    }

    void createChannelParser(int channel, String contract) {
        this.channelParsers.put(channel, new ChannelEventsParser(QDContract.valueOf((String)contract), this.delegates));
    }

    void updateConfigChannelParser(int channel, String dataFormat, Map<String, List<String>> eventFields) {
        this.channelParsers.get(channel).updateConfig(dataFormat, eventFields);
    }

    private void parseSetup(int channel, JsonParser parser) throws IOException {
        String version = null;
        Long keepaliveTimeout = null;
        Long acceptKeepaliveTimeout = null;
        while (!parser.isClosed()) {
            if (parser.nextToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = parser.getCurrentName();
            if ("version".equals(fieldName)) {
                parser.nextToken();
                version = parser.getValueAsString();
                continue;
            }
            if ("keepaliveTimeout".equals(fieldName)) {
                if (parser.nextToken() == JsonToken.VALUE_NULL) continue;
                keepaliveTimeout = (long)(parser.getValueAsDouble() * 1000.0);
                continue;
            }
            if (!"acceptKeepaliveTimeout".equals(fieldName) || parser.nextToken() == JsonToken.VALUE_NULL) continue;
            acceptKeepaliveTimeout = (long)(parser.getValueAsDouble() * 1000.0);
        }
        this.receiver.receiveSetup(version, keepaliveTimeout, acceptKeepaliveTimeout);
    }

    private void parseError(int channel, JsonParser parser) throws IOException {
        String error = null;
        String message = null;
        while (!parser.isClosed()) {
            if (parser.nextToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = parser.getCurrentName();
            if ("error".equals(fieldName)) {
                parser.nextToken();
                error = parser.getValueAsString();
                continue;
            }
            if (!"message".equals(fieldName)) continue;
            parser.nextToken();
            message = parser.getValueAsString();
        }
        this.receiver.receiveError(channel, error, message);
    }

    private void parseAuthState(int channel, JsonParser parser) throws IOException {
        while (!parser.isClosed()) {
            String fieldName;
            if (parser.nextToken() != JsonToken.FIELD_NAME || !"state".equals(fieldName = parser.getCurrentName())) continue;
            parser.nextToken();
            String state = parser.getValueAsString();
            this.receiver.receiveAuthState(channel, state);
            return;
        }
    }

    private void parseKeepalive(int channel, JsonParser parser) {
        this.receiver.receiveKeepalive(channel);
    }

    private void parseChannelOpened(int channel, JsonParser parser) throws IOException {
        String service = null;
        String contract = null;
        while (!parser.isClosed()) {
            if (parser.nextToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = parser.getCurrentName();
            if ("service".equals(fieldName)) {
                parser.nextToken();
                service = parser.getValueAsString();
            }
            if (!"parameters".equals(fieldName)) continue;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.currentToken() != JsonToken.FIELD_NAME || !"contract".equals(parser.getCurrentName())) continue;
                parser.nextToken();
                contract = parser.getValueAsString();
            }
        }
        this.receiver.receiveChannelOpened(channel, service, contract);
    }

    private void parseFeedConfig(int channel, JsonParser parser) throws IOException {
        Long aggregationPeriod = null;
        String dataFormat = null;
        Map<String, List<String>> eventFields = Collections.emptyMap();
        while (!parser.isClosed()) {
            if (parser.nextToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = parser.getCurrentName();
            if ("aggregationPeriod".equals(fieldName)) {
                if (parser.nextToken() == JsonToken.VALUE_NULL) continue;
                aggregationPeriod = (long)(parser.getValueAsDouble() * 1000.0);
                continue;
            }
            if ("dataFormat".equals(fieldName)) {
                parser.nextToken();
                dataFormat = parser.getValueAsString();
                continue;
            }
            if (!"eventFields".equals(fieldName)) continue;
            eventFields = DxLinkJsonMessageParser.parseEventFields(parser);
        }
        this.receiver.receiveFeedConfig(channel, aggregationPeriod, dataFormat, eventFields);
    }

    private void parseFeedData(int channel, JsonParser parser) throws IOException {
        while (!parser.isClosed()) {
            String fieldName;
            if (JsonToken.FIELD_NAME != parser.nextToken() || !"data".equals(fieldName = parser.getCurrentName())) continue;
            parser.nextToken();
            this.receiver.receiveFeedData(this.channelParsers.get(channel).init(parser));
            return;
        }
    }

    private static interface MessageParsingStrategy {
        public void process(int var1, JsonParser var2) throws IOException;
    }
}

