/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.transport;

import com.devexperts.auth.AuthToken;
import com.devexperts.logging.Logging;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketApplicationConnectionFactory;
import com.devexperts.qd.dxlink.websocket.transport.DxLinkLoginHandlerFactory;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.InvalidFormatException;
import com.dxfeed.promise.Promise;

@ServiceProvider
public class TokenDxLinkLoginHandlerFactory
implements DxLinkLoginHandlerFactory {
    public static final TokenDxLinkLoginHandlerFactory INSTANCE = new TokenDxLinkLoginHandlerFactory();
    public static final String DXLINK_AUTHORIZATION_SCHEME = "dxlink";
    private static final Logging log = Logging.getLogging(TokenDxLinkLoginHandlerFactory.class);

    @Override
    public QDLoginHandler createLoginHandler(String login, DxLinkWebSocketApplicationConnectionFactory factory) throws InvalidFormatException {
        boolean hasToken;
        if (!login.startsWith("dxlink:")) {
            return null;
        }
        boolean bl = hasToken = login.length() > "dxlink:".length();
        if (!hasToken) {
            log.error("Auth scheme 'dxlink' login must be specified as: dxlink[:<token>]");
            return null;
        }
        String token = login.substring(DXLINK_AUTHORIZATION_SCHEME.length() + 1);
        log.info("Using auth scheme 'dxlink' with token: " + token);
        return new AutherLoginHandler(token);
    }

    protected static class AutherLoginHandler
    implements QDLoginHandler {
        private final AuthToken token;

        public AutherLoginHandler(String token) {
            this.token = AuthToken.createCustomToken((String)TokenDxLinkLoginHandlerFactory.DXLINK_AUTHORIZATION_SCHEME, (String)token);
        }

        public Promise<AuthToken> login(String reason) {
            if ("UNAUTHORIZED".equals(reason)) {
                return Promise.completed((Object)this.token);
            }
            log.error("Server rejected token: " + reason);
            return Promise.failed((Throwable)new SecurityException(reason));
        }

        public AuthToken getAuthToken() {
            return null;
        }
    }
}

