/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketApplicationConnectionFactory;
import com.devexperts.qd.dxlink.websocket.transport.DxLinkClientWebSocketConnector;
import com.devexperts.qd.qtp.MessageAdapterConnectionFactory;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorFactory;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.SystemProperties;

@ServiceProvider
public class DxLinkWebSocketConnectorFactory
implements MessageConnectorFactory {
    private static final String DXLINK_PREFIX = "dxlink:";
    private static final String DXFEED_EXPERIMENTAL_DXLINK_ENABLE = "dxfeed.experimental.dxlink.enable";
    private static final boolean ENABLE_EXPERIMENTAL_FEATURE = SystemProperties.getBooleanProperty((String)"dxfeed.experimental.dxlink.enable", (boolean)false);

    public MessageConnector createMessageConnector(ApplicationConnectionFactory factory, String address) throws InvalidFormatException {
        if (!address.startsWith(DXLINK_PREFIX)) {
            return null;
        }
        if (!ENABLE_EXPERIMENTAL_FEATURE) {
            throw new IllegalStateException("This feature is experimental. You should enable the system property 'dxfeed.experimental.dxlink.enable' before using it.");
        }
        return new DxLinkClientWebSocketConnector(new DxLinkWebSocketApplicationConnectionFactory(((MessageAdapterConnectionFactory)factory).getMessageAdapterFactory()), address.substring(DXLINK_PREFIX.length()));
    }

    public Class<? extends MessageConnector> getResultingClass() {
        return DxLinkClientWebSocketConnector.class;
    }
}

