/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.application;

import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.dxlink.websocket.application.Delegates;
import com.devexperts.qd.dxlink.websocket.application.DxLinkClientReceiver;
import com.devexperts.qd.dxlink.websocket.application.DxLinkJsonMessageFactory;
import com.devexperts.qd.dxlink.websocket.application.DxLinkJsonMessageParser;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketApplicationConnection;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketQTPComposer;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketQTPParser;
import com.devexperts.qd.dxlink.websocket.application.HeartbeatProcessor;
import com.devexperts.qd.dxlink.websocket.transport.DxLinkLoginHandlerFactory;
import com.devexperts.qd.dxlink.websocket.transport.TokenDxLinkLoginHandlerFactory;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.services.Services;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DxLinkWebSocketApplicationConnectionFactory
extends ApplicationConnectionFactory {
    private static final Pattern acceptEventFieldsValidator = Pattern.compile("^\\((\\w+\\[\\w+(,\\w+)*])(,\\w+\\[\\w+(,\\w+)*])*\\)$");
    private static final Pattern acceptEventFieldsParser = Pattern.compile("(\\w+)\\[([^]]+)]");
    private static final String APPLICATION_VERSION = SystemProperties.getProperty((String)"com.devexperts.qd.dxlink.applicationVersion", null);
    private static final String ACCEPT_EVENT_FIELDS = SystemProperties.getProperty((String)"com.devexperts.qd.dxlink.websocket.acceptEventFields", (String)"");
    private static final TimePeriod DEFAULT_HEARTBEAT_TIMEOUT = TimePeriod.valueOf((String)SystemProperties.getProperty((String)"com.devexperts.qd.dxlink.websocket.heartbeatTimeout", (String)"60s"));
    private static final TimePeriod ACCEPT_AGGREGATION_PERIOD = TimePeriod.valueOf((String)SystemProperties.getProperty((String)"com.devexperts.qd.dxlink.feedService.acceptAggregationPeriod", (String)"0s"));
    private TimePeriod heartbeatTimeout = DEFAULT_HEARTBEAT_TIMEOUT;
    private String applicationVersion = APPLICATION_VERSION;
    private TimePeriod acceptAggregationPeriod = ACCEPT_AGGREGATION_PERIOD;
    private String acceptEventFields = ACCEPT_EVENT_FIELDS;
    private Map<String, List<String>> acceptEventFieldsByType = Collections.emptyMap();
    private MessageAdapter.ConfigurableFactory factory;
    private QDLoginHandler loginHandler;

    public DxLinkWebSocketApplicationConnectionFactory(MessageAdapter.ConfigurableFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
    }

    public ApplicationConnection<?> createConnection(TransportConnection transportConnection) {
        QDStats stats = (QDStats)transportConnection.variables().get(MessageConnectors.STATS_KEY);
        if (stats == null) {
            stats = QDStats.VOID;
        }
        MessageAdapter adapter = this.factory.createAdapter(stats);
        adapter.setConnectionVariables(transportConnection.variables());
        adapter.setLoginHandler(this.loginHandler);
        adapter.useDescribeProtocol();
        HeartbeatProcessor heartbeatProcessor = new HeartbeatProcessor(this.getHeartbeatTimeout().getTime());
        Delegates delegates = new Delegates(adapter.getScheme());
        return new DxLinkWebSocketApplicationConnection(adapter, this, transportConnection, new DxLinkWebSocketQTPParser(adapter.getScheme(), adapter.supportsMixedSubscription(), adapter.getFieldReplacer(), heartbeatProcessor, receiver -> new DxLinkJsonMessageParser((DxLinkClientReceiver)receiver, delegates)), new DxLinkWebSocketQTPComposer(adapter.getScheme(), delegates, new DxLinkJsonMessageFactory(), heartbeatProcessor, this), heartbeatProcessor);
    }

    public DxLinkWebSocketApplicationConnectionFactory clone() {
        DxLinkWebSocketApplicationConnectionFactory clone = (DxLinkWebSocketApplicationConnectionFactory)super.clone();
        clone.factory = this.factory.clone();
        return clone;
    }

    public Set<ConfigurationKey<?>> supportedConfiguration() {
        LinkedHashSet set = new LinkedHashSet(super.supportedConfiguration());
        set.addAll(this.factory.supportedConfiguration());
        return set;
    }

    public <T> T getConfiguration(ConfigurationKey<T> key) {
        if (super.supportedConfiguration().contains(key)) {
            return (T)super.getConfiguration(key);
        }
        return (T)this.factory.getConfiguration(key);
    }

    public <T> boolean setConfiguration(ConfigurationKey<T> key, T value) {
        if (super.supportedConfiguration().contains(key)) {
            return super.setConfiguration(key, value);
        }
        return this.factory.setConfiguration(key, value);
    }

    @Configurable(description="Login plugin")
    public void setLogin(String login) {
        for (DxLinkLoginHandlerFactory factory : Services.createServices(DxLinkLoginHandlerFactory.class, null)) {
            this.loginHandler = factory.createLoginHandler(login, this);
            if (this.loginHandler == null) continue;
            return;
        }
        this.loginHandler = TokenDxLinkLoginHandlerFactory.INSTANCE.createLoginHandler(login, this);
    }

    public QDLoginHandler getLogin() {
        return this.loginHandler;
    }

    public TimePeriod getAcceptAggregationPeriod() {
        return this.acceptAggregationPeriod;
    }

    @Configurable(description="accept aggregation period")
    public void setAcceptAggregationPeriod(TimePeriod acceptAggregationPeriod) {
        if (acceptAggregationPeriod.getTime() < 0L) {
            throw new IllegalArgumentException("cannot be negative");
        }
        this.acceptAggregationPeriod = acceptAggregationPeriod;
    }

    public TimePeriod getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    @Configurable(description="heartbeat timeout for this connection")
    public void setHeartbeatTimeout(TimePeriod heartbeatTimeout) {
        if (heartbeatTimeout.getTime() <= 0L) {
            throw new IllegalArgumentException("cannot be negative or zero");
        }
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public String getAcceptEventFields() {
        return this.acceptEventFields;
    }

    @Configurable(description="accept event fields")
    public void setAcceptEventFields(String acceptEventFields) {
        this.acceptEventFieldsByType = DxLinkWebSocketApplicationConnectionFactory.parseAcceptEventFields(acceptEventFields);
        this.acceptEventFields = acceptEventFields;
    }

    public List<String> getAcceptedEventFieldsByType(String eventType) {
        return this.acceptEventFieldsByType.getOrDefault(eventType, Collections.emptyList());
    }

    static Map<String, List<String>> parseAcceptEventFields(String acceptEventFields) {
        if (!acceptEventFieldsValidator.matcher(acceptEventFields).matches()) {
            throw new IllegalArgumentException("Invalid acceptEventFields format");
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Matcher matcher = acceptEventFieldsParser.matcher(acceptEventFields);
        while (matcher.find()) {
            String eventType = matcher.group(1);
            String[] fields = matcher.group(2).split(",");
            result.put(eventType, Arrays.asList(fields));
        }
        return result;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Configurable(description="client application version")
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public Map<String, String> getAgentInfo() {
        TreeMap<String, String> agent = new TreeMap<String, String>();
        agent.put("version", QDFactory.getVersion());
        if (this.getApplicationVersion() != null) {
            agent.put("application", this.getApplicationVersion());
        }
        agent.put("platform", SystemProperties.getProperty((String)"os.name", null) + " " + SystemProperties.getProperty((String)"os.version", null));
        String javaVersion = SystemProperties.getProperty((String)"java.version", null);
        if (javaVersion != null) {
            agent.put("java", javaVersion);
        }
        return agent;
    }

    public String toString() {
        return this.factory.toString();
    }
}

