/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.transport;

import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.qd.dxlink.websocket.transport.WebSocketTransportConnection;
import com.devexperts.qd.qtp.QTPWorkerThread;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;

class WebSocketWriter
extends QTPWorkerThread {
    private static final long MAX_WAIT_TIME = TimePeriod.valueOf((String)SystemProperties.getProperty(WebSocketWriter.class, (String)"maxWaitTime", (String)"1m")).getTime();
    private static final AtomicIntegerFieldUpdater<WebSocketWriter> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WebSocketWriter.class, "state");
    private static final int STATE_IDLE = 0;
    private static final int STATE_AVAILABLE = 1;
    private static final int STATE_PARKED = 2;
    private final WebSocketTransportConnection transportConnection;
    private volatile int state = 0;

    WebSocketWriter(WebSocketTransportConnection transportConnection) {
        super((Object)((Object)transportConnection) + "-Writer");
        this.transportConnection = transportConnection;
    }

    private boolean casState(int expect, int update) {
        return STATE_UPDATER.compareAndSet(this, expect, update);
    }

    protected void doWork() throws InterruptedException, IOException {
        WebSocketTransportConnection.Session session = this.transportConnection.createSession();
        if (session == null) {
            return;
        }
        while (!this.isClosed()) {
            if (this.state != 1 && this.waitAvailableOrClosed(session.application)) {
                return;
            }
            assert (this.state == 1);
            this.state = 0;
            for (ByteBuf message : session.application.retrieveMessages()) {
                session.writeAndFlush(message);
            }
        }
    }

    private boolean waitAvailableOrClosed(ApplicationConnection<?> connection) throws InterruptedException {
        do {
            long waitTime;
            long currentTime = System.currentTimeMillis();
            long examineTime = connection.examine(currentTime);
            if (this.isClosed()) {
                return true;
            }
            if (this.state == 1) {
                return false;
            }
            if (examineTime <= currentTime) {
                this.log.warn("INVARIANT VIOLATION DETECTED: examineTime <= currentTime but chunks are not available");
                examineTime = currentTime + 10L;
            }
            if ((waitTime = examineTime - currentTime) < 0L || waitTime > MAX_WAIT_TIME) {
                waitTime = MAX_WAIT_TIME;
            }
            if (!this.casState(0, 2)) {
                return false;
            }
            this.doPark(waitTime);
        } while (this.casState(2, 0));
        return false;
    }

    private void doPark(long waitTime) {
        boolean verboseDebug;
        boolean bl = verboseDebug = this.transportConnection.verbose && this.log.debugEnabled();
        if (verboseDebug) {
            this.log.debug("Parking for " + waitTime + " ms until more data is ready to send");
        }
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(waitTime));
        if (verboseDebug) {
            this.log.debug("Unparked");
        }
    }

    protected void handleShutdown() {
        this.transportConnection.stopConnector();
    }

    protected void handleClose(Throwable reason) {
        this.transportConnection.exitSocket(reason);
    }

    void chunksAvailable() {
        int state = this.state;
        if (state == 0 ? this.casState(0, 1) : state == 1) {
            return;
        }
        this.state = 1;
        LockSupport.unpark((Thread)((Object)this));
    }
}

