/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSEvent;
import com.devexperts.mars.common.MARSListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MARSAgent {
    private final MARS mars;
    private Collection<MARSEvent> events;
    private MARSListener listener;

    public MARSAgent(MARS mars) {
        if (mars == null) {
            throw new NullPointerException();
        }
        this.mars = mars;
        this.events = mars.addAgent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MARSEvent> retrieveEvents() {
        MARS mARS = this.mars;
        synchronized (mARS) {
            List events = this.events;
            this.events = null;
            return events != null ? events : Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(MARSListener listener) {
        MARS mARS = this.mars;
        synchronized (mARS) {
            this.listener = listener;
            if (this.events == null || this.events.isEmpty()) {
                return;
            }
        }
        this.fireListener();
    }

    public void close() {
        this.mars.removeAgent(this);
    }

    protected MARSListener getListener() {
        return this.listener;
    }

    void addEvents(Collection<MARSEvent> events) {
        if (this.events == null) {
            this.events = new ArrayList<MARSEvent>(Math.max(events.size(), 5));
        }
        if (events instanceof ArrayList) {
            for (int i = 0; i < events.size(); ++i) {
                this.events.add((MARSEvent)((ArrayList)events).get(i));
            }
        } else {
            this.events.addAll(events);
        }
    }

    void fireListener() {
        MARSListener listener = this.listener;
        if (listener != null) {
            listener.marsChanged(this);
        }
    }
}

