/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector;

import com.devexperts.connector.ConnectionAdapter;
import com.devexperts.connector.ConnectorListener;
import com.devexperts.connector.ConnectorMBean;
import com.devexperts.connector.SocketAcceptor;
import com.devexperts.connector.SocketConnector;
import com.devexperts.connector.SocketController;
import com.devexperts.logging.Logging;
import java.net.Socket;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;

public abstract class Connector
implements ConnectorMBean {
    private static final Logging log = Logging.getLogging(Connector.class);
    public static final String SYS_PROPERTY_NO_ADV_STATISTICS = "com.devexperts.connector.no-adv-stat";
    protected static final boolean isAdvancedStatEnabled = !Boolean.getBoolean("com.devexperts.connector.no-adv-stat");
    private int heartbeat_period;
    private int heartbeat_timeout;
    private int reconnection_period;
    private final Random skew_random = new Random();
    private double skew_factor;
    private int skew_multiplier;
    private final Map<String, SocketController> controllers = new HashMap<String, SocketController>();
    private boolean started;
    private String address = "";
    private ConnectorListener connectorListener;

    public Connector() {
        this.setReconnectionPeriod(10000);
        this.setSkewFactor(0.3);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + this.address;
    }

    @Override
    public int getHeartbeatPeriod() {
        return this.heartbeat_period;
    }

    @Override
    public void setHeartbeatPeriod(int heartbeat_period) {
        if (heartbeat_period < 0) {
            throw new IllegalArgumentException("Heartbeat period is negative.");
        }
        this.heartbeat_period = heartbeat_period;
    }

    @Override
    public int getHeartbeatTimeout() {
        return this.heartbeat_timeout;
    }

    @Override
    public void setHeartbeatTimeout(int heartbeat_timeout) {
        if (heartbeat_timeout < 0) {
            throw new IllegalArgumentException("Heartbeat timeout is negative.");
        }
        this.heartbeat_timeout = heartbeat_timeout;
    }

    @Override
    public int getReconnectionPeriod() {
        return this.reconnection_period;
    }

    @Override
    public void setReconnectionPeriod(int reconnection_period) {
        if (reconnection_period < 0) {
            throw new IllegalArgumentException("Recconection period is negative.");
        }
        this.reconnection_period = reconnection_period;
    }

    @Override
    public double getSkewFactor() {
        return this.skew_factor;
    }

    @Override
    public void setSkewFactor(double skew_factor) {
        if (Double.isNaN(skew_factor) || skew_factor < 0.0 || skew_factor > 1.0) {
            throw new IllegalArgumentException("Skew factor is outside [0, 1] interval.");
        }
        this.skew_factor = skew_factor;
        this.skew_multiplier = (int)(skew_factor * 65536.0);
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public synchronized void setAddress(String address) {
        this.address = address = address == null ? "" : address.trim();
        HashSet<String> addresses = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(address, "/");
        while (st.hasMoreTokens()) {
            addresses.add(st.nextToken().trim());
        }
        addresses.remove("");
        for (String s : addresses) {
            if (this.controllers.containsKey(s)) continue;
            this.controllers.put(s, null);
        }
        Iterator<String> it = this.controllers.keySet().iterator();
        while (it.hasNext()) {
            String s;
            s = it.next();
            if (addresses.contains(s)) continue;
            SocketController controller = this.controllers.get(s);
            it.remove();
            if (controller == null) continue;
            controller.close();
        }
        if (this.started) {
            this.start();
        }
    }

    @Override
    public synchronized void start() {
        this.started = true;
        for (String key : this.controllers.keySet()) {
            if (this.controllers.get(key) != null) continue;
            try {
                SocketController controller = key.charAt(0) == ':' ? new SocketAcceptor(this, key) : new SocketConnector(this, key);
                this.controllers.put(key, controller);
                controller.start();
            }
            catch (ParseException e) {
                this.log("Parsing failed key=" + key, e, null);
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.started = false;
        for (String s : this.controllers.keySet()) {
            SocketController controller = this.controllers.put(s, null);
            if (controller == null) continue;
            controller.close();
        }
    }

    @Override
    public synchronized void restart() {
        this.stop();
        this.start();
    }

    public ConnectorListener getConnectorListener() {
        return this.connectorListener;
    }

    public synchronized void setConnectorListener(ConnectorListener connectorListener) {
        this.connectorListener = connectorListener;
    }

    protected abstract ConnectionAdapter createConnectionAdapter(Socket var1) throws Throwable;

    protected int getSkewedPeriod(int period) {
        if (period <= 0 || this.skew_multiplier == 0) {
            return period;
        }
        return period - (int)((long)period * (long)this.skew_multiplier * (long)(this.skew_random.nextInt() >>> 16) >>> 32);
    }

    protected void log(String message, Throwable error, String state) {
        this.log(message, error, true, state);
    }

    protected void fireConnectorListenerProcessing(String message, Throwable error, String state) {
        if (this.connectorListener != null) {
            int index;
            if (message != null && message.charAt(0) == '[' && (index = message.indexOf(93)) != -1) {
                message = message.substring(index + 1);
            }
            if (state == null) {
                if (error == null) {
                    this.connectorListener.info(message);
                } else {
                    this.connectorListener.errorOccured(message, error);
                }
            } else if ("DISCONNECTED".equals(state)) {
                this.connectorListener.connectionLost(message, error);
            } else if ("ESTABLISHED".equals(state)) {
                this.connectorListener.connectionEstablished(message);
            } else {
                this.connectorListener.errorOccured(message, error);
                log.error("Wrong unknown state value for: " + message, error);
            }
        }
    }

    protected void log(String message, Throwable error, boolean shouldBePrintStackTrace, String state) {
        if (shouldBePrintStackTrace && error != null) {
            log.error(message, error);
        } else if (error != null) {
            log.info(message + ": " + error);
        } else {
            log.info(message);
        }
        if (isAdvancedStatEnabled) {
            this.fireConnectorListenerProcessing(message, error, state);
        }
    }

    protected String getSocketAddress(Socket socket) {
        return socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
    }
}

