/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

import com.devexperts.mars.common.MARSAgent;
import com.devexperts.mars.common.MARSEvent;
import com.devexperts.mars.common.MARSEventFactory;
import com.devexperts.mars.common.MARSStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MARS {
    private final Map<String, MARSEvent> events = new HashMap<String, MARSEvent>();
    private final Set<MARSAgent> agents = new HashSet<MARSAgent>();
    private MARSAgent[] agents_array;
    private ArrayList<MARSEvent> filtered_events;
    private final MARSEventFactory marsEventFactory = MARSEventFactory.getInstance();
    private static final Comparator<MARSEvent> EVENT_NAME_COMPARATOR = new Comparator<MARSEvent>(){

        @Override
        public int compare(MARSEvent e1, MARSEvent e2) {
            return e1.getName().compareTo(e2.getName());
        }
    };

    public String getValue(String name) {
        MARSEvent event = this.getEvent(name);
        return event == null ? null : event.getValue();
    }

    public void setValue(String name, String value, long timestamp) {
        this.putEvent(new MARSEvent(name, value, timestamp));
    }

    public void setValue(String name, String value) {
        this.putEvent(this.marsEventFactory.createMARSEvent(name, value));
    }

    public synchronized MARSEvent getEvent(String name) {
        return this.events.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEvent(MARSEvent event) {
        MARSAgent[] agents_array;
        MARS mARS = this;
        synchronized (mARS) {
            ArrayList<MARSEvent> filtered = this.getFiltered();
            this.processEvent(event, filtered);
            agents_array = this.addEvents(filtered);
            filtered.clear();
            this.filtered_events = filtered;
        }
        MARS.fireListeners(agents_array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEvents(Collection<MARSEvent> events) {
        MARSAgent[] agents_array;
        if (events.isEmpty()) {
            return;
        }
        MARS mARS = this;
        synchronized (mARS) {
            ArrayList<MARSEvent> filtered = this.getFiltered();
            for (MARSEvent event : events) {
                this.processEvent(event, filtered);
            }
            agents_array = this.addEvents(filtered);
            filtered.clear();
            this.filtered_events = filtered;
        }
        MARS.fireListeners(agents_array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticEvents(Collection<MARSEvent> events) {
        MARSAgent[] agents_array;
        if (events.isEmpty()) {
            return;
        }
        MARS mARS = this;
        synchronized (mARS) {
            HashSet<String> nodes = new HashSet<String>();
            for (MARSEvent event : events) {
                if (event.getName().endsWith(".status") && MARSStatus.find(event.getValue()) == MARSStatus.REMOVED || event != this.events.get(event.getName())) continue;
                this.events.remove(event.getName());
                nodes.add(event.getNodeName());
            }
            ArrayList<MARSEvent> filtered = new ArrayList<MARSEvent>();
            for (String node : nodes) {
                filtered.add(this.marsEventFactory.createMARSEvent(node + ".status", MARSStatus.REMOVED.getName()));
                MARSEvent event = this.events.get(node + ".category");
                if (event != null) {
                    filtered.add(event);
                }
                if ((event = this.events.get(node + ".description")) != null) {
                    filtered.add(event);
                }
                if ((event = this.events.get(node + ".status")) != null) {
                    filtered.add(event);
                }
                if ((event = this.events.get(node + ".value")) == null) continue;
                filtered.add(event);
            }
            agents_array = this.addEvents(filtered);
        }
        MARS.fireListeners(agents_array);
    }

    synchronized Map<String, MARSEvent> getEvents() {
        return this.events;
    }

    synchronized Collection<MARSEvent> addAgent(MARSAgent agent) {
        this.agents.add(agent);
        this.agents_array = null;
        ArrayList<MARSEvent> result = new ArrayList<MARSEvent>(this.events.values());
        Collections.sort(result, EVENT_NAME_COMPARATOR);
        return result;
    }

    synchronized void removeAgent(MARSAgent agent) {
        this.agents.remove(agent);
        this.agents_array = null;
    }

    private ArrayList<MARSEvent> getFiltered() {
        ArrayList<MARSEvent> filtered = this.filtered_events;
        if (filtered == null) {
            filtered = new ArrayList();
        } else {
            this.filtered_events = null;
        }
        filtered.clear();
        return filtered;
    }

    private void processEvent(MARSEvent event, Collection<MARSEvent> filtered) {
        if (event.getName().endsWith(".status") && MARSStatus.find(event.getValue()) == MARSStatus.REMOVED) {
            String nodeName = event.getNodeName();
            if (this.events.remove(nodeName + ".category") != null | this.events.remove(nodeName + ".description") != null | this.events.remove(nodeName + ".status") != null | this.events.remove(nodeName + ".value") != null) {
                filtered.add(event);
            }
        } else {
            MARSEvent oldEvent = this.events.put(event.getName(), event);
            if (oldEvent == null || !oldEvent.getValue().equals(event.getValue()) || oldEvent.getTimestamp() != event.getTimestamp()) {
                filtered.add(event);
            }
        }
    }

    private MARSAgent[] addEvents(Collection<MARSEvent> filtered) {
        MARSAgent[] agents_array;
        if (filtered.isEmpty() || this.agents.isEmpty()) {
            return null;
        }
        if (this.agents_array == null) {
            this.agents_array = this.agents.toArray(new MARSAgent[this.agents.size()]);
        }
        for (MARSAgent agent : agents_array = this.agents_array) {
            agent.addEvents(filtered);
        }
        return agents_array;
    }

    private static void fireListeners(MARSAgent[] agents_array) {
        if (agents_array != null) {
            for (MARSAgent agent : agents_array) {
                agent.fireListener();
            }
        }
    }
}

