/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

import java.util.Date;

public class MARSEvent {
    public static final String PARAM_TYPE_VALUE = ".value";
    public static final String PARAM_TYPE_STATUS = ".status";
    public static final String PARAM_TYPE_CATEGORY = ".category";
    public static final String PARAM_TYPE_DESCRIPTION = ".description";
    private final String name;
    private final String value;
    private final long timestamp;

    public MARSEvent(String name, String value) {
        this(name, value, 0L);
    }

    public MARSEvent(String name, String value, long timestamp) {
        this.timestamp = timestamp;
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getNodeName() {
        if (this.isValueEvent() || this.isStatusEvent() || this.isCategoryEvent() || this.isDescriptionEvent()) {
            return this.name.substring(0, this.name.lastIndexOf(46));
        }
        return this.name;
    }

    public boolean isDescriptionEvent() {
        return this.name.endsWith(PARAM_TYPE_DESCRIPTION);
    }

    public boolean isCategoryEvent() {
        return this.name.endsWith(PARAM_TYPE_CATEGORY);
    }

    public boolean isValueEvent() {
        return this.name.endsWith(PARAM_TYPE_VALUE);
    }

    public boolean isStatusEvent() {
        return this.name.endsWith(PARAM_TYPE_STATUS);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.timestamp == 0L ? this.name + "=" + this.value : this.name + "=" + this.timestamp + "|" + this.value;
    }

    public static String toString(MARSEvent event) {
        if (event == null) {
            return "MARSEvent{null}";
        }
        return "MARSEvent{name=" + event.name + ", value=" + event.value + ", timestamp=" + event.timestamp + " -> " + new Date(event.timestamp) + "}";
    }
}

