/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARSNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class MARSScheduler {
    public static final String MARS_DELAY_PROPERTY = "mars.delay";
    public static final int MARS_DELAY = Integer.getInteger("mars.delay", 10);
    private static final MARSScheduler INSTANCE = new MARSScheduler();
    private final HashMap<Long, Task> tasks = new HashMap();
    private final DelayQueue<Task> queue = new DelayQueue();
    private volatile Thread scheduler;

    public static void schedule(Runnable command) {
        INSTANCE.scheduleInternal(command, command, MARS_DELAY, TimeUnit.SECONDS);
    }

    public static void schedule(Runnable command, long period, TimeUnit unit) {
        INSTANCE.scheduleInternal(command, command, period, unit);
    }

    public static void watch(final Object o, MARSNode node) {
        INSTANCE.scheduleInternal(o, new Watcher(node){

            @Override
            public void run() {
                this.node.setValue(o.toString());
            }
        }, MARS_DELAY, TimeUnit.SECONDS);
    }

    public static void watchSize(final Collection<?> c, MARSNode node) {
        INSTANCE.scheduleInternal(c, new Watcher(node){

            @Override
            public void run() {
                this.node.setIntValue(c.size());
            }
        }, MARS_DELAY, TimeUnit.SECONDS);
    }

    public static void watchDelta(final Number number, MARSNode node) {
        INSTANCE.scheduleInternal(number, new Watcher(node){
            private double value;

            @Override
            public void run() {
                double oldValue = this.value;
                this.value = number.doubleValue();
                this.node.setDoubleValue(this.value - oldValue);
            }
        }, MARS_DELAY, TimeUnit.SECONDS);
    }

    public static void watchTimeRate(final Number number, final double multiplier, int precision, MARSNode node) {
        if (Double.isNaN(multiplier) || Double.isInfinite(multiplier) || multiplier == 0.0) {
            throw new IllegalArgumentException("multiplier is undefined");
        }
        if (precision < -18 || precision > 18) {
            throw new IllegalArgumentException("precision is out of range");
        }
        long power = 1L;
        while (precision-- > 0) {
            power *= 10L;
        }
        final long scale = power;
        INSTANCE.scheduleInternal(number, new Watcher(node){
            private long time;
            private double value;
            {
                super(node);
                this.time = System.currentTimeMillis();
                this.value = number.doubleValue();
            }

            @Override
            public void run() {
                long oldTime = this.time;
                this.time = System.currentTimeMillis();
                double oldValue = this.value;
                this.value = number.doubleValue();
                this.node.setDoubleValue(this.time <= oldTime ? 0.0 : Math.floor((this.value - oldValue) * multiplier * 1000.0 / (double)(this.time - oldTime) * (double)scale + 0.5) / (double)scale);
            }
        }, MARS_DELAY, TimeUnit.SECONDS);
    }

    public static void cancel(Object o) {
        INSTANCE.cancelInternal(o);
    }

    private MARSScheduler() {
    }

    private synchronized void scheduleInternal(Object key, Runnable command, long period, TimeUnit unit) {
        List<Runnable> commands;
        if (key == null || command == null) {
            throw new NullPointerException();
        }
        if ((period = unit.toNanos(period)) <= 0L || period >= Long.MAX_VALUE) {
            throw new IllegalArgumentException("period must be positive finite number");
        }
        Task task = this.tasks.get(period);
        if (task == null) {
            task = new Task(period);
            this.tasks.put(period, task);
            this.queue.add(task);
        }
        if ((commands = task.commands.get(key)) == null) {
            commands = new ArrayList<Runnable>(1);
            task.commands.put(key, commands);
        }
        commands.add(command);
        task.commandsCache = null;
        if (this.scheduler == null) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    MARSScheduler.this.runInternal();
                }
            }, "MonitoringScheduler");
            t.setDaemon(true);
            t.start();
            this.scheduler = t;
        }
    }

    private synchronized void cancelInternal(Object key) {
        Iterator<Task> it = this.tasks.values().iterator();
        while (it.hasNext()) {
            Task task = it.next();
            if (!task.commands.containsKey(key)) continue;
            for (Runnable command : (List)task.commands.remove(key)) {
                if (!(command instanceof Watcher)) continue;
                ((Watcher)command).node.remove();
            }
            task.commandsCache = null;
            if (!task.commands.isEmpty()) continue;
            it.remove();
            if (!this.tasks.isEmpty() || this.scheduler == null) continue;
            this.scheduler.interrupt();
            this.scheduler = null;
        }
    }

    private synchronized void clearSchedulerInstance() {
        if (this.scheduler == Thread.currentThread()) {
            this.scheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal() {
        while (true) {
            try {
                while (true) {
                    Task task = (Task)this.queue.take();
                    List<Runnable> commands = task.commandsCache;
                    if (commands == null) {
                        MARSScheduler mARSScheduler = this;
                        synchronized (mARSScheduler) {
                            if (task.commands.isEmpty()) {
                                continue;
                            }
                            commands = new ArrayList<Runnable>(task.commands.size() * 5 / 4 + 1);
                            for (List<Runnable> c : task.commands.values()) {
                                commands.addAll(c);
                            }
                            task.commandsCache = commands;
                        }
                    }
                    for (Runnable command : commands) {
                        try {
                            command.run();
                        }
                        catch (Throwable t) {
                            MARSScheduler.log().error("Error running scheduled command:", t);
                        }
                    }
                    task.updateTime();
                    this.queue.add(task);
                }
            }
            catch (InterruptedException e) {
                this.clearSchedulerInstance();
                return;
            }
            catch (Throwable t) {
                try {
                    MARSScheduler.log().error("Scheduling error:", t);
                }
                catch (Throwable throwable) {
                    this.clearSchedulerInstance();
                    throw throwable;
                }
            }
        }
    }

    private static Logging log() {
        return Logging.getLogging(MARSScheduler.class);
    }

    private static abstract class Watcher
    implements Runnable {
        final MARSNode node;

        Watcher(MARSNode node) {
            if (node == null) {
                throw new NullPointerException();
            }
            this.node = node;
        }
    }

    private static class Task
    implements Delayed {
        final long period;
        long time;
        final LinkedHashMap<Object, List<Runnable>> commands = new LinkedHashMap();
        volatile List<Runnable> commandsCache;

        Task(long period) {
            this.period = period;
            this.updateTime();
        }

        void updateTime() {
            this.time = Math.max(this.time, (TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis()) + this.period / 2L) / this.period * this.period) + this.period;
        }

        @Override
        public long getDelay(@Nonnull TimeUnit unit) {
            return unit.convert(this.time - TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis()), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@Nonnull Delayed delayed) {
            Task other = (Task)delayed;
            if (this.time < other.time) {
                return -1;
            }
            if (this.time > other.time) {
                return 1;
            }
            if (this.period < other.period) {
                return -1;
            }
            if (this.period > other.period) {
                return 1;
            }
            return 0;
        }
    }
}

