/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common.net;

import com.devexperts.connector.ConnectionAdapter;
import com.devexperts.connector.ConnectionAdapterListener;
import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSAgent;
import com.devexperts.mars.common.MARSEvent;
import com.devexperts.mars.common.MARSListener;
import com.devexperts.mars.common.net.MARSBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MARSConnectionAdapter
implements ConnectionAdapter,
MARSListener {
    private final MARS mars;
    private final boolean isMars;
    private final MARSAgent agent;
    private final boolean isAgent;
    private final int read_buffer_limit;
    private final Map<String, MARSEvent> read_events = new HashMap<String, MARSEvent>();
    private final MARSBuffer read_buffer;
    private final MARSBuffer write_buffer;
    private final InputStreamReader reader;
    private final OutputStreamWriter writer;
    private ConnectionAdapterListener listener;

    public MARSConnectionAdapter(MARS mars, MARSAgent agent, int read_buffer_limit, InputStream in, OutputStream out) {
        this.mars = mars;
        this.isMars = mars != null;
        this.agent = agent;
        this.isAgent = agent != null;
        this.read_buffer_limit = read_buffer_limit;
        this.read_buffer = new MARSBuffer();
        this.write_buffer = new MARSBuffer();
        this.reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        this.writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        if (this.isAgent) {
            agent.setListener(this);
        }
    }

    @Override
    public void marsChanged(MARSAgent agent) {
        ConnectionAdapterListener listener = this.listener;
        if (listener != null) {
            listener.dataAvailable(this);
        }
    }

    @Override
    public void setListener(ConnectionAdapterListener listener) {
        this.listener = listener;
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<MARSEvent> events;
        ConnectionAdapterListener listener;
        if (this.isAgent) {
            this.agent.close();
        }
        if ((listener = this.listener) != null) {
            listener.adapterClosed(this);
        }
        Map<String, MARSEvent> map = this.read_events;
        synchronized (map) {
            events = new ArrayList<MARSEvent>(this.read_events.values());
        }
        if (this.isMars) {
            this.mars.removeAuthenticEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readData() throws Throwable {
        if (this.read_buffer.getSize() > this.read_buffer_limit) {
            throw new IOException("Input buffer too large: " + this.read_buffer.getSize());
        }
        int reserve = Math.max(this.read_buffer.getSize(), 4096);
        this.read_buffer.ensureCapacity(this.read_buffer.getSize() + reserve);
        int chars = this.reader.read(this.read_buffer.getBuffer(), this.read_buffer.getSize(), reserve);
        if (chars > 0) {
            this.read_buffer.setSize(this.read_buffer.getSize() + chars);
            Collection<MARSEvent> events = this.read_buffer.readEvents();
            if (this.isMars) {
                Map<String, MARSEvent> map = this.read_events;
                synchronized (map) {
                    for (MARSEvent event : events) {
                        this.read_events.put(event.getName(), event);
                    }
                }
                this.mars.putEvents(events);
            }
        }
        return chars;
    }

    @Override
    public int writeData() throws Throwable {
        if (this.isAgent) {
            this.write_buffer.writeEvents(this.agent.retrieveEvents());
        }
        return this.flushWriteData();
    }

    @Override
    public int writeHeartbeat() throws Throwable {
        this.write_buffer.writeString("\r\n");
        return this.flushWriteData();
    }

    private int flushWriteData() throws Throwable {
        int chars = this.write_buffer.getSize();
        if (chars > 0) {
            this.writer.write(this.write_buffer.getBuffer(), 0, this.write_buffer.getSize());
            this.writer.flush();
            this.write_buffer.removeChars(this.write_buffer.getSize());
        }
        return chars;
    }
}

