/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.jvm;

import com.devexperts.logging.Logging;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CpuCounter {
    private static final AtomicInteger CPU_COUNTER_INSTANCES = new AtomicInteger();
    private boolean initialized;
    private long processTime;
    private long userTime;

    private static Logging log() {
        return Logging.getLogging(CpuCounter.class);
    }

    public CpuCounter() {
        try {
            Accessor.start();
            this.readout();
            this.initialized = true;
            CPU_COUNTER_INSTANCES.getAndIncrement();
        }
        catch (Throwable t) {
            CpuCounter.log().error("Failed to start CPU monitor:", t);
        }
    }

    private void readout() {
        for (int attempts = 0; attempts < 10; ++attempts) {
            Accessor a = Accessor.currentAccessor;
            this.processTime = a.processTime;
            this.userTime = a.userTime;
            if (a == Accessor.currentAccessor) break;
        }
    }

    private long getProcessCpuTime() {
        return Accessor.currentAccessor.cpuTime;
    }

    public long getCpuTime() {
        if (!this.initialized) {
            return 0L;
        }
        return this.getProcessCpuTime();
    }

    public double getCpuUsage() {
        if (!this.initialized) {
            return 0.0;
        }
        long prevProcessTime = this.processTime;
        long prevUserTime = this.userTime;
        this.readout();
        return Math.floor(10000.0 * (double)Math.max(0L, this.userTime - prevUserTime) / (double)Math.max(1L, this.processTime - prevProcessTime) + 0.5) / 10000.0;
    }

    public synchronized void close() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (CPU_COUNTER_INSTANCES.decrementAndGet() == 0) {
            Accessor.stop();
        }
    }

    private static class Accessor
    implements Runnable {
        static final long MS = 1000000L;
        static final long INACCURACY = 30000000L;
        static final long JUMP = 600000000000L;
        static final OperatingSystemMXBean OS = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        static volatile Accessor currentAccessor;
        static Thread currentThread;
        int availableProcessors;
        long realTime;
        long processTime;
        long cpuTime;
        long userTime;

        static synchronized void start() {
            if (currentThread != null && currentThread.isAlive()) {
                return;
            }
            currentAccessor = new Accessor();
            currentAccessor.readout();
            currentThread = new Thread((Runnable)new Accessor(), "CpuMonitor");
            currentThread.setDaemon(true);
            currentThread.setPriority(10);
            currentThread.start();
        }

        static synchronized void stop() {
            if (currentThread != null) {
                currentThread.interrupt();
                currentThread = null;
            }
        }

        Accessor() {
        }

        private void readout() {
            for (int attempts = 0; attempts < 10; ++attempts) {
                long time = System.currentTimeMillis();
                long real = Math.min(Math.max(0L, time), 9223372036554L) * 1000000L;
                long process = System.nanoTime();
                if (attempts > 0 && real == this.realTime && process >= this.processTime && process < this.processTime + 100000L) break;
                this.availableProcessors = Math.max(1, OS.getAvailableProcessors());
                this.realTime = real;
                this.processTime = process;
                this.cpuTime = OS.getProcessCpuTime();
                this.userTime = this.cpuTime / (long)this.availableProcessors;
            }
        }

        @Override
        public void run() {
            try {
                Accessor[] accessors = new Accessor[100];
                for (int i = 0; i < accessors.length; ++i) {
                    accessors[i] = new Accessor();
                }
                int currentIndex = 0;
                Accessor prev = new Accessor();
                Accessor next = new Accessor();
                prev.readout();
                Accessor tmp = accessors[currentIndex];
                tmp.availableProcessors = prev.availableProcessors;
                tmp.realTime = prev.realTime;
                tmp.processTime = prev.processTime;
                tmp.cpuTime = prev.cpuTime;
                tmp.userTime = prev.userTime;
                currentAccessor = tmp;
                long period = 99L;
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(period);
                            next.readout();
                            long real = next.realTime - prev.realTime;
                            if (real < period * 1000000L - 30000000L || real >= period * 1000000L + 600000000000L) {
                                CpuCounter.log().warn("Real time changed by " + real / 1000000L + " ms in " + period + " ms");
                            }
                            if (real < period * 1000000L + 600000000000L) {
                                long process = next.processTime - prev.processTime;
                                if (process < (real = Math.max(real, period * 1000000L)) - 30000000L || process > real + 30000000L) {
                                    CpuCounter.log().warn("Process time changed by " + process / 1000000L + " ms in " + real / 1000000L + " ms");
                                }
                                process = Math.max(process, real);
                                long cpu = next.cpuTime - prev.cpuTime;
                                long user = cpu / (long)next.availableProcessors;
                                if (user < 0L || user > process + 30000000L) {
                                    CpuCounter.log().warn("CPU time changed by " + user / 1000000L + " ms in " + process / 1000000L + " ms");
                                } else {
                                    cpu = Math.min(cpu, process * (long)next.availableProcessors);
                                    user = Math.min(user, process);
                                    currentIndex = (currentIndex + 1) % accessors.length;
                                    tmp = accessors[currentIndex];
                                    tmp.availableProcessors = next.availableProcessors;
                                    tmp.realTime = next.realTime;
                                    tmp.processTime = Accessor.currentAccessor.processTime + process;
                                    tmp.cpuTime = Accessor.currentAccessor.cpuTime + cpu;
                                    tmp.userTime = Accessor.currentAccessor.userTime + user;
                                    currentAccessor = tmp;
                                }
                            }
                            tmp = prev;
                            prev = next;
                            next = tmp;
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (Throwable t) {
                        CpuCounter.log().error("Failed to monitor CPU time:", t);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                CpuCounter.log().error("Failed to monitor CPU time:", t);
                return;
            }
        }
    }
}

